/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.listingsitems;

import com.amazon.spapi.model.listingsitems.Money;
import com.amazon.spapi.model.listingsitems.Points;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Offer details of a listings item for an Amazon marketplace.")
public class ItemOfferByMarketplace {
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="offerType")
    private OfferTypeEnum offerType = null;
    @SerializedName(value="price")
    private Money price = null;
    @SerializedName(value="points")
    private Points points = null;

    public ItemOfferByMarketplace marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @ApiModelProperty(required=true, value="Amazon marketplace identifier.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public ItemOfferByMarketplace offerType(OfferTypeEnum offerType) {
        this.offerType = offerType;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of offer for the listings item.")
    public OfferTypeEnum getOfferType() {
        return this.offerType;
    }

    public void setOfferType(OfferTypeEnum offerType) {
        this.offerType = offerType;
    }

    public ItemOfferByMarketplace price(Money price) {
        this.price = price;
        return this;
    }

    @ApiModelProperty(required=true, value="Purchase price of the listings item")
    public Money getPrice() {
        return this.price;
    }

    public void setPrice(Money price) {
        this.price = price;
    }

    public ItemOfferByMarketplace points(Points points) {
        this.points = points;
        return this;
    }

    @ApiModelProperty(value="")
    public Points getPoints() {
        return this.points;
    }

    public void setPoints(Points points) {
        this.points = points;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemOfferByMarketplace itemOfferByMarketplace = (ItemOfferByMarketplace)o;
        return Objects.equals(this.marketplaceId, itemOfferByMarketplace.marketplaceId) && Objects.equals((Object)this.offerType, (Object)itemOfferByMarketplace.offerType) && Objects.equals(this.price, itemOfferByMarketplace.price) && Objects.equals(this.points, itemOfferByMarketplace.points);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.marketplaceId, this.offerType, this.price, this.points});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemOfferByMarketplace {\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    offerType: ").append(this.toIndentedString((Object)this.offerType)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    points: ").append(this.toIndentedString(this.points)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OfferTypeEnum {
        B2C("B2C"),
        B2B("B2B");

        private String value;

        private OfferTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OfferTypeEnum fromValue(String text) {
            for (OfferTypeEnum b : OfferTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<OfferTypeEnum> {
            public void write(JsonWriter jsonWriter, OfferTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OfferTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OfferTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

