/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentoutbound;

import com.amazon.spapi.model.fulfillmentoutbound.DeliveryWindowList;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Delivery information for a scheduled delivery.")
public class ScheduledDeliveryInfo {
    @SerializedName(value="deliveryTimeZone")
    private String deliveryTimeZone = null;
    @SerializedName(value="deliveryWindows")
    private DeliveryWindowList deliveryWindows = null;

    public ScheduledDeliveryInfo deliveryTimeZone(String deliveryTimeZone) {
        this.deliveryTimeZone = deliveryTimeZone;
        return this;
    }

    @ApiModelProperty(required=true, value="The time zone of the destination address for the fulfillment order preview. Must be an IANA time zone name. Example: Asia/Tokyo.")
    public String getDeliveryTimeZone() {
        return this.deliveryTimeZone;
    }

    public void setDeliveryTimeZone(String deliveryTimeZone) {
        this.deliveryTimeZone = deliveryTimeZone;
    }

    public ScheduledDeliveryInfo deliveryWindows(DeliveryWindowList deliveryWindows) {
        this.deliveryWindows = deliveryWindows;
        return this;
    }

    @ApiModelProperty(required=true, value="An array of time ranges that are available for scheduled delivery.")
    public DeliveryWindowList getDeliveryWindows() {
        return this.deliveryWindows;
    }

    public void setDeliveryWindows(DeliveryWindowList deliveryWindows) {
        this.deliveryWindows = deliveryWindows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduledDeliveryInfo scheduledDeliveryInfo = (ScheduledDeliveryInfo)o;
        return Objects.equals(this.deliveryTimeZone, scheduledDeliveryInfo.deliveryTimeZone) && Objects.equals(this.deliveryWindows, scheduledDeliveryInfo.deliveryWindows);
    }

    public int hashCode() {
        return Objects.hash(this.deliveryTimeZone, this.deliveryWindows);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScheduledDeliveryInfo {\n");
        sb.append("    deliveryTimeZone: ").append(this.toIndentedString(this.deliveryTimeZone)).append("\n");
        sb.append("    deliveryWindows: ").append(this.toIndentedString(this.deliveryWindows)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

