/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentoutbound;

import com.amazon.spapi.model.fulfillmentoutbound.FulfillmentPreviewItemList;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Delivery and item information for a shipment in a fulfillment order preview.")
public class FulfillmentPreviewShipment {
    @SerializedName(value="earliestShipDate")
    private String earliestShipDate = null;
    @SerializedName(value="latestShipDate")
    private String latestShipDate = null;
    @SerializedName(value="earliestArrivalDate")
    private String earliestArrivalDate = null;
    @SerializedName(value="latestArrivalDate")
    private String latestArrivalDate = null;
    @SerializedName(value="shippingNotes")
    private List<String> shippingNotes = null;
    @SerializedName(value="fulfillmentPreviewItems")
    private FulfillmentPreviewItemList fulfillmentPreviewItems = null;

    public FulfillmentPreviewShipment earliestShipDate(String earliestShipDate) {
        this.earliestShipDate = earliestShipDate;
        return this;
    }

    @ApiModelProperty(value="The earliest date that the shipment is expected to be sent from the fulfillment center, in ISO 8601 date time format.")
    public String getEarliestShipDate() {
        return this.earliestShipDate;
    }

    public void setEarliestShipDate(String earliestShipDate) {
        this.earliestShipDate = earliestShipDate;
    }

    public FulfillmentPreviewShipment latestShipDate(String latestShipDate) {
        this.latestShipDate = latestShipDate;
        return this;
    }

    @ApiModelProperty(value="The latest date that the shipment is expected to be sent from the fulfillment center, in ISO 8601 date time format.")
    public String getLatestShipDate() {
        return this.latestShipDate;
    }

    public void setLatestShipDate(String latestShipDate) {
        this.latestShipDate = latestShipDate;
    }

    public FulfillmentPreviewShipment earliestArrivalDate(String earliestArrivalDate) {
        this.earliestArrivalDate = earliestArrivalDate;
        return this;
    }

    @ApiModelProperty(value="The earliest date that the shipment is expected to arrive at its destination.")
    public String getEarliestArrivalDate() {
        return this.earliestArrivalDate;
    }

    public void setEarliestArrivalDate(String earliestArrivalDate) {
        this.earliestArrivalDate = earliestArrivalDate;
    }

    public FulfillmentPreviewShipment latestArrivalDate(String latestArrivalDate) {
        this.latestArrivalDate = latestArrivalDate;
        return this;
    }

    @ApiModelProperty(value="The latest date that the shipment is expected to arrive at its destination, in ISO 8601 date time format.")
    public String getLatestArrivalDate() {
        return this.latestArrivalDate;
    }

    public void setLatestArrivalDate(String latestArrivalDate) {
        this.latestArrivalDate = latestArrivalDate;
    }

    public FulfillmentPreviewShipment shippingNotes(List<String> shippingNotes) {
        this.shippingNotes = shippingNotes;
        return this;
    }

    public FulfillmentPreviewShipment addShippingNotesItem(String shippingNotesItem) {
        if (this.shippingNotes == null) {
            this.shippingNotes = new ArrayList<String>();
        }
        this.shippingNotes.add(shippingNotesItem);
        return this;
    }

    @ApiModelProperty(value="Provides additional insight into the shipment timeline when exact delivery dates are not able to be precomputed.")
    public List<String> getShippingNotes() {
        return this.shippingNotes;
    }

    public void setShippingNotes(List<String> shippingNotes) {
        this.shippingNotes = shippingNotes;
    }

    public FulfillmentPreviewShipment fulfillmentPreviewItems(FulfillmentPreviewItemList fulfillmentPreviewItems) {
        this.fulfillmentPreviewItems = fulfillmentPreviewItems;
        return this;
    }

    @ApiModelProperty(required=true, value="Information about the items in the shipment.")
    public FulfillmentPreviewItemList getFulfillmentPreviewItems() {
        return this.fulfillmentPreviewItems;
    }

    public void setFulfillmentPreviewItems(FulfillmentPreviewItemList fulfillmentPreviewItems) {
        this.fulfillmentPreviewItems = fulfillmentPreviewItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FulfillmentPreviewShipment fulfillmentPreviewShipment = (FulfillmentPreviewShipment)o;
        return Objects.equals(this.earliestShipDate, fulfillmentPreviewShipment.earliestShipDate) && Objects.equals(this.latestShipDate, fulfillmentPreviewShipment.latestShipDate) && Objects.equals(this.earliestArrivalDate, fulfillmentPreviewShipment.earliestArrivalDate) && Objects.equals(this.latestArrivalDate, fulfillmentPreviewShipment.latestArrivalDate) && Objects.equals(this.shippingNotes, fulfillmentPreviewShipment.shippingNotes) && Objects.equals(this.fulfillmentPreviewItems, fulfillmentPreviewShipment.fulfillmentPreviewItems);
    }

    public int hashCode() {
        return Objects.hash(this.earliestShipDate, this.latestShipDate, this.earliestArrivalDate, this.latestArrivalDate, this.shippingNotes, this.fulfillmentPreviewItems);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FulfillmentPreviewShipment {\n");
        sb.append("    earliestShipDate: ").append(this.toIndentedString(this.earliestShipDate)).append("\n");
        sb.append("    latestShipDate: ").append(this.toIndentedString(this.latestShipDate)).append("\n");
        sb.append("    earliestArrivalDate: ").append(this.toIndentedString(this.earliestArrivalDate)).append("\n");
        sb.append("    latestArrivalDate: ").append(this.toIndentedString(this.latestArrivalDate)).append("\n");
        sb.append("    shippingNotes: ").append(this.toIndentedString(this.shippingNotes)).append("\n");
        sb.append("    fulfillmentPreviewItems: ").append(this.toIndentedString(this.fulfillmentPreviewItems)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

