/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentoutbound;

import com.amazon.spapi.model.fulfillmentoutbound.Weight;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Item information for a shipment in a fulfillment order preview.")
public class FulfillmentPreviewItem {
    @SerializedName(value="sellerSku")
    private String sellerSku = null;
    @SerializedName(value="quantity")
    private Integer quantity = null;
    @SerializedName(value="sellerFulfillmentOrderItemId")
    private String sellerFulfillmentOrderItemId = null;
    @SerializedName(value="estimatedShippingWeight")
    private Weight estimatedShippingWeight = null;
    @SerializedName(value="shippingWeightCalculationMethod")
    private ShippingWeightCalculationMethodEnum shippingWeightCalculationMethod = null;

    public FulfillmentPreviewItem sellerSku(String sellerSku) {
        this.sellerSku = sellerSku;
        return this;
    }

    @ApiModelProperty(required=true, value="The seller SKU of the item.")
    public String getSellerSku() {
        return this.sellerSku;
    }

    public void setSellerSku(String sellerSku) {
        this.sellerSku = sellerSku;
    }

    public FulfillmentPreviewItem quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(required=true, value="The item quantity.")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public FulfillmentPreviewItem sellerFulfillmentOrderItemId(String sellerFulfillmentOrderItemId) {
        this.sellerFulfillmentOrderItemId = sellerFulfillmentOrderItemId;
        return this;
    }

    @ApiModelProperty(required=true, value="A fulfillment order item identifier that the seller created with a call to the createFulfillmentOrder operation.")
    public String getSellerFulfillmentOrderItemId() {
        return this.sellerFulfillmentOrderItemId;
    }

    public void setSellerFulfillmentOrderItemId(String sellerFulfillmentOrderItemId) {
        this.sellerFulfillmentOrderItemId = sellerFulfillmentOrderItemId;
    }

    public FulfillmentPreviewItem estimatedShippingWeight(Weight estimatedShippingWeight) {
        this.estimatedShippingWeight = estimatedShippingWeight;
        return this;
    }

    @ApiModelProperty(value="The estimated shipping weight of the item quantity for a single item, as identified by sellerSku, in a shipment.")
    public Weight getEstimatedShippingWeight() {
        return this.estimatedShippingWeight;
    }

    public void setEstimatedShippingWeight(Weight estimatedShippingWeight) {
        this.estimatedShippingWeight = estimatedShippingWeight;
    }

    public FulfillmentPreviewItem shippingWeightCalculationMethod(ShippingWeightCalculationMethodEnum shippingWeightCalculationMethod) {
        this.shippingWeightCalculationMethod = shippingWeightCalculationMethod;
        return this;
    }

    @ApiModelProperty(value="The method used to calculate the estimated shipping weight.")
    public ShippingWeightCalculationMethodEnum getShippingWeightCalculationMethod() {
        return this.shippingWeightCalculationMethod;
    }

    public void setShippingWeightCalculationMethod(ShippingWeightCalculationMethodEnum shippingWeightCalculationMethod) {
        this.shippingWeightCalculationMethod = shippingWeightCalculationMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FulfillmentPreviewItem fulfillmentPreviewItem = (FulfillmentPreviewItem)o;
        return Objects.equals(this.sellerSku, fulfillmentPreviewItem.sellerSku) && Objects.equals(this.quantity, fulfillmentPreviewItem.quantity) && Objects.equals(this.sellerFulfillmentOrderItemId, fulfillmentPreviewItem.sellerFulfillmentOrderItemId) && Objects.equals(this.estimatedShippingWeight, fulfillmentPreviewItem.estimatedShippingWeight) && Objects.equals((Object)this.shippingWeightCalculationMethod, (Object)fulfillmentPreviewItem.shippingWeightCalculationMethod);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sellerSku, this.quantity, this.sellerFulfillmentOrderItemId, this.estimatedShippingWeight, this.shippingWeightCalculationMethod});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FulfillmentPreviewItem {\n");
        sb.append("    sellerSku: ").append(this.toIndentedString(this.sellerSku)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    sellerFulfillmentOrderItemId: ").append(this.toIndentedString(this.sellerFulfillmentOrderItemId)).append("\n");
        sb.append("    estimatedShippingWeight: ").append(this.toIndentedString(this.estimatedShippingWeight)).append("\n");
        sb.append("    shippingWeightCalculationMethod: ").append(this.toIndentedString((Object)this.shippingWeightCalculationMethod)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ShippingWeightCalculationMethodEnum {
        PACKAGE("Package"),
        DIMENSIONAL("Dimensional");

        private String value;

        private ShippingWeightCalculationMethodEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ShippingWeightCalculationMethodEnum fromValue(String text) {
            for (ShippingWeightCalculationMethodEnum b : ShippingWeightCalculationMethodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ShippingWeightCalculationMethodEnum> {
            public void write(JsonWriter jsonWriter, ShippingWeightCalculationMethodEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ShippingWeightCalculationMethodEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ShippingWeightCalculationMethodEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

