/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentoutbound;

import com.amazon.spapi.model.fulfillmentoutbound.FeatureSettings;
import com.amazon.spapi.model.fulfillmentoutbound.FeeList;
import com.amazon.spapi.model.fulfillmentoutbound.FulfillmentPreviewShipmentList;
import com.amazon.spapi.model.fulfillmentoutbound.ScheduledDeliveryInfo;
import com.amazon.spapi.model.fulfillmentoutbound.ShippingSpeedCategory;
import com.amazon.spapi.model.fulfillmentoutbound.StringList;
import com.amazon.spapi.model.fulfillmentoutbound.UnfulfillablePreviewItemList;
import com.amazon.spapi.model.fulfillmentoutbound.Weight;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Information about a fulfillment order preview, including delivery and fee information based on shipping method.")
public class FulfillmentPreview {
    @SerializedName(value="shippingSpeedCategory")
    private ShippingSpeedCategory shippingSpeedCategory = null;
    @SerializedName(value="scheduledDeliveryInfo")
    private ScheduledDeliveryInfo scheduledDeliveryInfo = null;
    @SerializedName(value="isFulfillable")
    private Boolean isFulfillable = null;
    @SerializedName(value="isCODCapable")
    private Boolean isCODCapable = null;
    @SerializedName(value="estimatedShippingWeight")
    private Weight estimatedShippingWeight = null;
    @SerializedName(value="estimatedFees")
    private FeeList estimatedFees = null;
    @SerializedName(value="fulfillmentPreviewShipments")
    private FulfillmentPreviewShipmentList fulfillmentPreviewShipments = null;
    @SerializedName(value="unfulfillablePreviewItems")
    private UnfulfillablePreviewItemList unfulfillablePreviewItems = null;
    @SerializedName(value="orderUnfulfillableReasons")
    private StringList orderUnfulfillableReasons = null;
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="featureConstraints")
    private List<FeatureSettings> featureConstraints = null;

    public FulfillmentPreview shippingSpeedCategory(ShippingSpeedCategory shippingSpeedCategory) {
        this.shippingSpeedCategory = shippingSpeedCategory;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ShippingSpeedCategory getShippingSpeedCategory() {
        return this.shippingSpeedCategory;
    }

    public void setShippingSpeedCategory(ShippingSpeedCategory shippingSpeedCategory) {
        this.shippingSpeedCategory = shippingSpeedCategory;
    }

    public FulfillmentPreview scheduledDeliveryInfo(ScheduledDeliveryInfo scheduledDeliveryInfo) {
        this.scheduledDeliveryInfo = scheduledDeliveryInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public ScheduledDeliveryInfo getScheduledDeliveryInfo() {
        return this.scheduledDeliveryInfo;
    }

    public void setScheduledDeliveryInfo(ScheduledDeliveryInfo scheduledDeliveryInfo) {
        this.scheduledDeliveryInfo = scheduledDeliveryInfo;
    }

    public FulfillmentPreview isFulfillable(Boolean isFulfillable) {
        this.isFulfillable = isFulfillable;
        return this;
    }

    @ApiModelProperty(required=true, value="When true, this fulfillment order preview is fulfillable.")
    public Boolean isIsFulfillable() {
        return this.isFulfillable;
    }

    public void setIsFulfillable(Boolean isFulfillable) {
        this.isFulfillable = isFulfillable;
    }

    public FulfillmentPreview isCODCapable(Boolean isCODCapable) {
        this.isCODCapable = isCODCapable;
        return this;
    }

    @ApiModelProperty(required=true, value="When true, this fulfillment order preview is for COD (Cash On Delivery).")
    public Boolean isIsCODCapable() {
        return this.isCODCapable;
    }

    public void setIsCODCapable(Boolean isCODCapable) {
        this.isCODCapable = isCODCapable;
    }

    public FulfillmentPreview estimatedShippingWeight(Weight estimatedShippingWeight) {
        this.estimatedShippingWeight = estimatedShippingWeight;
        return this;
    }

    @ApiModelProperty(value="Estimated shipping weight for this fulfillment order preview.")
    public Weight getEstimatedShippingWeight() {
        return this.estimatedShippingWeight;
    }

    public void setEstimatedShippingWeight(Weight estimatedShippingWeight) {
        this.estimatedShippingWeight = estimatedShippingWeight;
    }

    public FulfillmentPreview estimatedFees(FeeList estimatedFees) {
        this.estimatedFees = estimatedFees;
        return this;
    }

    @ApiModelProperty(value="The estimated fulfillment fees for this fulfillment order preview, if applicable.")
    public FeeList getEstimatedFees() {
        return this.estimatedFees;
    }

    public void setEstimatedFees(FeeList estimatedFees) {
        this.estimatedFees = estimatedFees;
    }

    public FulfillmentPreview fulfillmentPreviewShipments(FulfillmentPreviewShipmentList fulfillmentPreviewShipments) {
        this.fulfillmentPreviewShipments = fulfillmentPreviewShipments;
        return this;
    }

    @ApiModelProperty(value="")
    public FulfillmentPreviewShipmentList getFulfillmentPreviewShipments() {
        return this.fulfillmentPreviewShipments;
    }

    public void setFulfillmentPreviewShipments(FulfillmentPreviewShipmentList fulfillmentPreviewShipments) {
        this.fulfillmentPreviewShipments = fulfillmentPreviewShipments;
    }

    public FulfillmentPreview unfulfillablePreviewItems(UnfulfillablePreviewItemList unfulfillablePreviewItems) {
        this.unfulfillablePreviewItems = unfulfillablePreviewItems;
        return this;
    }

    @ApiModelProperty(value="")
    public UnfulfillablePreviewItemList getUnfulfillablePreviewItems() {
        return this.unfulfillablePreviewItems;
    }

    public void setUnfulfillablePreviewItems(UnfulfillablePreviewItemList unfulfillablePreviewItems) {
        this.unfulfillablePreviewItems = unfulfillablePreviewItems;
    }

    public FulfillmentPreview orderUnfulfillableReasons(StringList orderUnfulfillableReasons) {
        this.orderUnfulfillableReasons = orderUnfulfillableReasons;
        return this;
    }

    @ApiModelProperty(value="Error codes associated with the fulfillment order preview that indicate why the order is not fulfillable.  Error code examples:  DeliverySLAUnavailable InvalidDestinationAddress")
    public StringList getOrderUnfulfillableReasons() {
        return this.orderUnfulfillableReasons;
    }

    public void setOrderUnfulfillableReasons(StringList orderUnfulfillableReasons) {
        this.orderUnfulfillableReasons = orderUnfulfillableReasons;
    }

    public FulfillmentPreview marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @ApiModelProperty(required=true, value="The marketplace the fulfillment order is placed against.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public FulfillmentPreview featureConstraints(List<FeatureSettings> featureConstraints) {
        this.featureConstraints = featureConstraints;
        return this;
    }

    public FulfillmentPreview addFeatureConstraintsItem(FeatureSettings featureConstraintsItem) {
        if (this.featureConstraints == null) {
            this.featureConstraints = new ArrayList<FeatureSettings>();
        }
        this.featureConstraints.add(featureConstraintsItem);
        return this;
    }

    @ApiModelProperty(value="A list of features and their fulfillment policies to apply to the order.")
    public List<FeatureSettings> getFeatureConstraints() {
        return this.featureConstraints;
    }

    public void setFeatureConstraints(List<FeatureSettings> featureConstraints) {
        this.featureConstraints = featureConstraints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FulfillmentPreview fulfillmentPreview = (FulfillmentPreview)o;
        return Objects.equals((Object)this.shippingSpeedCategory, (Object)fulfillmentPreview.shippingSpeedCategory) && Objects.equals(this.scheduledDeliveryInfo, fulfillmentPreview.scheduledDeliveryInfo) && Objects.equals(this.isFulfillable, fulfillmentPreview.isFulfillable) && Objects.equals(this.isCODCapable, fulfillmentPreview.isCODCapable) && Objects.equals(this.estimatedShippingWeight, fulfillmentPreview.estimatedShippingWeight) && Objects.equals(this.estimatedFees, fulfillmentPreview.estimatedFees) && Objects.equals(this.fulfillmentPreviewShipments, fulfillmentPreview.fulfillmentPreviewShipments) && Objects.equals(this.unfulfillablePreviewItems, fulfillmentPreview.unfulfillablePreviewItems) && Objects.equals(this.orderUnfulfillableReasons, fulfillmentPreview.orderUnfulfillableReasons) && Objects.equals(this.marketplaceId, fulfillmentPreview.marketplaceId) && Objects.equals(this.featureConstraints, fulfillmentPreview.featureConstraints);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.shippingSpeedCategory, this.scheduledDeliveryInfo, this.isFulfillable, this.isCODCapable, this.estimatedShippingWeight, this.estimatedFees, this.fulfillmentPreviewShipments, this.unfulfillablePreviewItems, this.orderUnfulfillableReasons, this.marketplaceId, this.featureConstraints});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FulfillmentPreview {\n");
        sb.append("    shippingSpeedCategory: ").append(this.toIndentedString((Object)this.shippingSpeedCategory)).append("\n");
        sb.append("    scheduledDeliveryInfo: ").append(this.toIndentedString(this.scheduledDeliveryInfo)).append("\n");
        sb.append("    isFulfillable: ").append(this.toIndentedString(this.isFulfillable)).append("\n");
        sb.append("    isCODCapable: ").append(this.toIndentedString(this.isCODCapable)).append("\n");
        sb.append("    estimatedShippingWeight: ").append(this.toIndentedString(this.estimatedShippingWeight)).append("\n");
        sb.append("    estimatedFees: ").append(this.toIndentedString(this.estimatedFees)).append("\n");
        sb.append("    fulfillmentPreviewShipments: ").append(this.toIndentedString(this.fulfillmentPreviewShipments)).append("\n");
        sb.append("    unfulfillablePreviewItems: ").append(this.toIndentedString(this.unfulfillablePreviewItems)).append("\n");
        sb.append("    orderUnfulfillableReasons: ").append(this.toIndentedString(this.orderUnfulfillableReasons)).append("\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    featureConstraints: ").append(this.toIndentedString(this.featureConstraints)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

