/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentoutbound;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Information about an SKU, including the count available, identifiers, and a list of overlapping SKUs that share the same inventory pool.")
public class FeatureSku {
    @SerializedName(value="sellerSku")
    private String sellerSku = null;
    @SerializedName(value="fnSku")
    private String fnSku = null;
    @SerializedName(value="asin")
    private String asin = null;
    @SerializedName(value="skuCount")
    private BigDecimal skuCount = null;
    @SerializedName(value="overlappingSkus")
    private List<String> overlappingSkus = null;

    public FeatureSku sellerSku(String sellerSku) {
        this.sellerSku = sellerSku;
        return this;
    }

    @ApiModelProperty(value="Used to identify an item in the given marketplace. SellerSKU is qualified by the seller's SellerId, which is included with every operation that you submit.")
    public String getSellerSku() {
        return this.sellerSku;
    }

    public void setSellerSku(String sellerSku) {
        this.sellerSku = sellerSku;
    }

    public FeatureSku fnSku(String fnSku) {
        this.fnSku = fnSku;
        return this;
    }

    @ApiModelProperty(value="The unique SKU used by Amazon's fulfillment network.")
    public String getFnSku() {
        return this.fnSku;
    }

    public void setFnSku(String fnSku) {
        this.fnSku = fnSku;
    }

    public FeatureSku asin(String asin) {
        this.asin = asin;
        return this;
    }

    @ApiModelProperty(value="The Amazon Standard Identification Number (ASIN) of the item.")
    public String getAsin() {
        return this.asin;
    }

    public void setAsin(String asin) {
        this.asin = asin;
    }

    public FeatureSku skuCount(BigDecimal skuCount) {
        this.skuCount = skuCount;
        return this;
    }

    @ApiModelProperty(value="The number of SKUs available for this service.")
    public BigDecimal getSkuCount() {
        return this.skuCount;
    }

    public void setSkuCount(BigDecimal skuCount) {
        this.skuCount = skuCount;
    }

    public FeatureSku overlappingSkus(List<String> overlappingSkus) {
        this.overlappingSkus = overlappingSkus;
        return this;
    }

    public FeatureSku addOverlappingSkusItem(String overlappingSkusItem) {
        if (this.overlappingSkus == null) {
            this.overlappingSkus = new ArrayList<String>();
        }
        this.overlappingSkus.add(overlappingSkusItem);
        return this;
    }

    @ApiModelProperty(value="Other seller SKUs that are shared across the same inventory.")
    public List<String> getOverlappingSkus() {
        return this.overlappingSkus;
    }

    public void setOverlappingSkus(List<String> overlappingSkus) {
        this.overlappingSkus = overlappingSkus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureSku featureSku = (FeatureSku)o;
        return Objects.equals(this.sellerSku, featureSku.sellerSku) && Objects.equals(this.fnSku, featureSku.fnSku) && Objects.equals(this.asin, featureSku.asin) && Objects.equals(this.skuCount, featureSku.skuCount) && Objects.equals(this.overlappingSkus, featureSku.overlappingSkus);
    }

    public int hashCode() {
        return Objects.hash(this.sellerSku, this.fnSku, this.asin, this.skuCount, this.overlappingSkus);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeatureSku {\n");
        sb.append("    sellerSku: ").append(this.toIndentedString(this.sellerSku)).append("\n");
        sb.append("    fnSku: ").append(this.toIndentedString(this.fnSku)).append("\n");
        sb.append("    asin: ").append(this.toIndentedString(this.asin)).append("\n");
        sb.append("    skuCount: ").append(this.toIndentedString(this.skuCount)).append("\n");
        sb.append("    overlappingSkus: ").append(this.toIndentedString(this.overlappingSkus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

