/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentoutbound;

import com.amazon.spapi.model.fulfillmentoutbound.Address;
import com.amazon.spapi.model.fulfillmentoutbound.CODSettings;
import com.amazon.spapi.model.fulfillmentoutbound.CreateFulfillmentOrderItemList;
import com.amazon.spapi.model.fulfillmentoutbound.DeliveryWindow;
import com.amazon.spapi.model.fulfillmentoutbound.FeatureSettings;
import com.amazon.spapi.model.fulfillmentoutbound.FulfillmentAction;
import com.amazon.spapi.model.fulfillmentoutbound.FulfillmentPolicy;
import com.amazon.spapi.model.fulfillmentoutbound.NotificationEmailList;
import com.amazon.spapi.model.fulfillmentoutbound.ShippingSpeedCategory;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The request body schema for the createFulfillmentOrder operation.")
public class CreateFulfillmentOrderRequest {
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="sellerFulfillmentOrderId")
    private String sellerFulfillmentOrderId = null;
    @SerializedName(value="displayableOrderId")
    private String displayableOrderId = null;
    @SerializedName(value="displayableOrderDate")
    private String displayableOrderDate = null;
    @SerializedName(value="displayableOrderComment")
    private String displayableOrderComment = null;
    @SerializedName(value="shippingSpeedCategory")
    private ShippingSpeedCategory shippingSpeedCategory = null;
    @SerializedName(value="deliveryWindow")
    private DeliveryWindow deliveryWindow = null;
    @SerializedName(value="destinationAddress")
    private Address destinationAddress = null;
    @SerializedName(value="fulfillmentAction")
    private FulfillmentAction fulfillmentAction = null;
    @SerializedName(value="fulfillmentPolicy")
    private FulfillmentPolicy fulfillmentPolicy = null;
    @SerializedName(value="codSettings")
    private CODSettings codSettings = null;
    @SerializedName(value="shipFromCountryCode")
    private String shipFromCountryCode = null;
    @SerializedName(value="notificationEmails")
    private NotificationEmailList notificationEmails = null;
    @SerializedName(value="featureConstraints")
    private List<FeatureSettings> featureConstraints = null;
    @SerializedName(value="items")
    private CreateFulfillmentOrderItemList items = null;

    public CreateFulfillmentOrderRequest marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @ApiModelProperty(value="The marketplace the fulfillment order is placed against.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public CreateFulfillmentOrderRequest sellerFulfillmentOrderId(String sellerFulfillmentOrderId) {
        this.sellerFulfillmentOrderId = sellerFulfillmentOrderId;
        return this;
    }

    @ApiModelProperty(required=true, value="A fulfillment order identifier that the seller creates to track their fulfillment order. The SellerFulfillmentOrderId must be unique for each fulfillment order that a seller creates. If the seller's system already creates unique order identifiers, then these might be good values for them to use.")
    public String getSellerFulfillmentOrderId() {
        return this.sellerFulfillmentOrderId;
    }

    public void setSellerFulfillmentOrderId(String sellerFulfillmentOrderId) {
        this.sellerFulfillmentOrderId = sellerFulfillmentOrderId;
    }

    public CreateFulfillmentOrderRequest displayableOrderId(String displayableOrderId) {
        this.displayableOrderId = displayableOrderId;
        return this;
    }

    @ApiModelProperty(required=true, value="A fulfillment order identifier that the seller creates. This value displays as the order identifier in recipient-facing materials such as the outbound shipment packing slip. The value of DisplayableOrderId should match the order identifier that the seller provides to the recipient. The seller can use the SellerFulfillmentOrderId for this value or they can specify an alternate value if they want the recipient to reference an alternate order identifier.  The value must be an alpha-numeric or ISO 8859-1 compliant string from one to 40 characters in length. Cannot contain two spaces in a row. Leading and trailing white space is removed.")
    public String getDisplayableOrderId() {
        return this.displayableOrderId;
    }

    public void setDisplayableOrderId(String displayableOrderId) {
        this.displayableOrderId = displayableOrderId;
    }

    public CreateFulfillmentOrderRequest displayableOrderDate(String displayableOrderDate) {
        this.displayableOrderDate = displayableOrderDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The date and time of the fulfillment order. Displays as the order date in recipient-facing materials such as the outbound shipment packing slip.")
    public String getDisplayableOrderDate() {
        return this.displayableOrderDate;
    }

    public void setDisplayableOrderDate(String displayableOrderDate) {
        this.displayableOrderDate = displayableOrderDate;
    }

    public CreateFulfillmentOrderRequest displayableOrderComment(String displayableOrderComment) {
        this.displayableOrderComment = displayableOrderComment;
        return this;
    }

    @ApiModelProperty(required=true, value="Order-specific text that appears in recipient-facing materials such as the outbound shipment packing slip.")
    public String getDisplayableOrderComment() {
        return this.displayableOrderComment;
    }

    public void setDisplayableOrderComment(String displayableOrderComment) {
        this.displayableOrderComment = displayableOrderComment;
    }

    public CreateFulfillmentOrderRequest shippingSpeedCategory(ShippingSpeedCategory shippingSpeedCategory) {
        this.shippingSpeedCategory = shippingSpeedCategory;
        return this;
    }

    @ApiModelProperty(required=true, value="The shipping method for the fulfillment order.")
    public ShippingSpeedCategory getShippingSpeedCategory() {
        return this.shippingSpeedCategory;
    }

    public void setShippingSpeedCategory(ShippingSpeedCategory shippingSpeedCategory) {
        this.shippingSpeedCategory = shippingSpeedCategory;
    }

    public CreateFulfillmentOrderRequest deliveryWindow(DeliveryWindow deliveryWindow) {
        this.deliveryWindow = deliveryWindow;
        return this;
    }

    @ApiModelProperty(value="")
    public DeliveryWindow getDeliveryWindow() {
        return this.deliveryWindow;
    }

    public void setDeliveryWindow(DeliveryWindow deliveryWindow) {
        this.deliveryWindow = deliveryWindow;
    }

    public CreateFulfillmentOrderRequest destinationAddress(Address destinationAddress) {
        this.destinationAddress = destinationAddress;
        return this;
    }

    @ApiModelProperty(required=true, value="The destination address for the fulfillment order.")
    public Address getDestinationAddress() {
        return this.destinationAddress;
    }

    public void setDestinationAddress(Address destinationAddress) {
        this.destinationAddress = destinationAddress;
    }

    public CreateFulfillmentOrderRequest fulfillmentAction(FulfillmentAction fulfillmentAction) {
        this.fulfillmentAction = fulfillmentAction;
        return this;
    }

    @ApiModelProperty(value="")
    public FulfillmentAction getFulfillmentAction() {
        return this.fulfillmentAction;
    }

    public void setFulfillmentAction(FulfillmentAction fulfillmentAction) {
        this.fulfillmentAction = fulfillmentAction;
    }

    public CreateFulfillmentOrderRequest fulfillmentPolicy(FulfillmentPolicy fulfillmentPolicy) {
        this.fulfillmentPolicy = fulfillmentPolicy;
        return this;
    }

    @ApiModelProperty(value="")
    public FulfillmentPolicy getFulfillmentPolicy() {
        return this.fulfillmentPolicy;
    }

    public void setFulfillmentPolicy(FulfillmentPolicy fulfillmentPolicy) {
        this.fulfillmentPolicy = fulfillmentPolicy;
    }

    public CreateFulfillmentOrderRequest codSettings(CODSettings codSettings) {
        this.codSettings = codSettings;
        return this;
    }

    @ApiModelProperty(value="")
    public CODSettings getCodSettings() {
        return this.codSettings;
    }

    public void setCodSettings(CODSettings codSettings) {
        this.codSettings = codSettings;
    }

    public CreateFulfillmentOrderRequest shipFromCountryCode(String shipFromCountryCode) {
        this.shipFromCountryCode = shipFromCountryCode;
        return this;
    }

    @ApiModelProperty(value="The two-character country code for the country from which the fulfillment order ships. Must be in ISO 3166-1 alpha-2 format.")
    public String getShipFromCountryCode() {
        return this.shipFromCountryCode;
    }

    public void setShipFromCountryCode(String shipFromCountryCode) {
        this.shipFromCountryCode = shipFromCountryCode;
    }

    public CreateFulfillmentOrderRequest notificationEmails(NotificationEmailList notificationEmails) {
        this.notificationEmails = notificationEmails;
        return this;
    }

    @ApiModelProperty(value="")
    public NotificationEmailList getNotificationEmails() {
        return this.notificationEmails;
    }

    public void setNotificationEmails(NotificationEmailList notificationEmails) {
        this.notificationEmails = notificationEmails;
    }

    public CreateFulfillmentOrderRequest featureConstraints(List<FeatureSettings> featureConstraints) {
        this.featureConstraints = featureConstraints;
        return this;
    }

    public CreateFulfillmentOrderRequest addFeatureConstraintsItem(FeatureSettings featureConstraintsItem) {
        if (this.featureConstraints == null) {
            this.featureConstraints = new ArrayList<FeatureSettings>();
        }
        this.featureConstraints.add(featureConstraintsItem);
        return this;
    }

    @ApiModelProperty(value="A list of features and their fulfillment policies to apply to the order.")
    public List<FeatureSettings> getFeatureConstraints() {
        return this.featureConstraints;
    }

    public void setFeatureConstraints(List<FeatureSettings> featureConstraints) {
        this.featureConstraints = featureConstraints;
    }

    public CreateFulfillmentOrderRequest items(CreateFulfillmentOrderItemList items) {
        this.items = items;
        return this;
    }

    @ApiModelProperty(required=true, value="A list of items to include in the fulfillment order preview, including quantity.")
    public CreateFulfillmentOrderItemList getItems() {
        return this.items;
    }

    public void setItems(CreateFulfillmentOrderItemList items) {
        this.items = items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateFulfillmentOrderRequest createFulfillmentOrderRequest = (CreateFulfillmentOrderRequest)o;
        return Objects.equals(this.marketplaceId, createFulfillmentOrderRequest.marketplaceId) && Objects.equals(this.sellerFulfillmentOrderId, createFulfillmentOrderRequest.sellerFulfillmentOrderId) && Objects.equals(this.displayableOrderId, createFulfillmentOrderRequest.displayableOrderId) && Objects.equals(this.displayableOrderDate, createFulfillmentOrderRequest.displayableOrderDate) && Objects.equals(this.displayableOrderComment, createFulfillmentOrderRequest.displayableOrderComment) && Objects.equals((Object)this.shippingSpeedCategory, (Object)createFulfillmentOrderRequest.shippingSpeedCategory) && Objects.equals(this.deliveryWindow, createFulfillmentOrderRequest.deliveryWindow) && Objects.equals(this.destinationAddress, createFulfillmentOrderRequest.destinationAddress) && Objects.equals((Object)this.fulfillmentAction, (Object)createFulfillmentOrderRequest.fulfillmentAction) && Objects.equals((Object)this.fulfillmentPolicy, (Object)createFulfillmentOrderRequest.fulfillmentPolicy) && Objects.equals(this.codSettings, createFulfillmentOrderRequest.codSettings) && Objects.equals(this.shipFromCountryCode, createFulfillmentOrderRequest.shipFromCountryCode) && Objects.equals(this.notificationEmails, createFulfillmentOrderRequest.notificationEmails) && Objects.equals(this.featureConstraints, createFulfillmentOrderRequest.featureConstraints) && Objects.equals(this.items, createFulfillmentOrderRequest.items);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.marketplaceId, this.sellerFulfillmentOrderId, this.displayableOrderId, this.displayableOrderDate, this.displayableOrderComment, this.shippingSpeedCategory, this.deliveryWindow, this.destinationAddress, this.fulfillmentAction, this.fulfillmentPolicy, this.codSettings, this.shipFromCountryCode, this.notificationEmails, this.featureConstraints, this.items});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateFulfillmentOrderRequest {\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    sellerFulfillmentOrderId: ").append(this.toIndentedString(this.sellerFulfillmentOrderId)).append("\n");
        sb.append("    displayableOrderId: ").append(this.toIndentedString(this.displayableOrderId)).append("\n");
        sb.append("    displayableOrderDate: ").append(this.toIndentedString(this.displayableOrderDate)).append("\n");
        sb.append("    displayableOrderComment: ").append(this.toIndentedString(this.displayableOrderComment)).append("\n");
        sb.append("    shippingSpeedCategory: ").append(this.toIndentedString((Object)this.shippingSpeedCategory)).append("\n");
        sb.append("    deliveryWindow: ").append(this.toIndentedString(this.deliveryWindow)).append("\n");
        sb.append("    destinationAddress: ").append(this.toIndentedString(this.destinationAddress)).append("\n");
        sb.append("    fulfillmentAction: ").append(this.toIndentedString((Object)this.fulfillmentAction)).append("\n");
        sb.append("    fulfillmentPolicy: ").append(this.toIndentedString((Object)this.fulfillmentPolicy)).append("\n");
        sb.append("    codSettings: ").append(this.toIndentedString(this.codSettings)).append("\n");
        sb.append("    shipFromCountryCode: ").append(this.toIndentedString(this.shipFromCountryCode)).append("\n");
        sb.append("    notificationEmails: ").append(this.toIndentedString(this.notificationEmails)).append("\n");
        sb.append("    featureConstraints: ").append(this.toIndentedString(this.featureConstraints)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

