/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentoutbound;

import com.amazon.spapi.model.fulfillmentoutbound.Money;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The COD (Cash On Delivery) charges that you associate with a COD fulfillment order.")
public class CODSettings {
    @SerializedName(value="isCodRequired")
    private Boolean isCodRequired = null;
    @SerializedName(value="codCharge")
    private Money codCharge = null;
    @SerializedName(value="codChargeTax")
    private Money codChargeTax = null;
    @SerializedName(value="shippingCharge")
    private Money shippingCharge = null;
    @SerializedName(value="shippingChargeTax")
    private Money shippingChargeTax = null;

    public CODSettings isCodRequired(Boolean isCodRequired) {
        this.isCodRequired = isCodRequired;
        return this;
    }

    @ApiModelProperty(required=true, value="When true, this fulfillment order requires a COD (Cash On Delivery) payment.")
    public Boolean isIsCodRequired() {
        return this.isCodRequired;
    }

    public void setIsCodRequired(Boolean isCodRequired) {
        this.isCodRequired = isCodRequired;
    }

    public CODSettings codCharge(Money codCharge) {
        this.codCharge = codCharge;
        return this;
    }

    @ApiModelProperty(value="The amount of the COD charge to be collected from the recipient for a COD order.")
    public Money getCodCharge() {
        return this.codCharge;
    }

    public void setCodCharge(Money codCharge) {
        this.codCharge = codCharge;
    }

    public CODSettings codChargeTax(Money codChargeTax) {
        this.codChargeTax = codChargeTax;
        return this;
    }

    @ApiModelProperty(value="The amount of the tax on the COD charge to be collected from the recipient for a COD order.")
    public Money getCodChargeTax() {
        return this.codChargeTax;
    }

    public void setCodChargeTax(Money codChargeTax) {
        this.codChargeTax = codChargeTax;
    }

    public CODSettings shippingCharge(Money shippingCharge) {
        this.shippingCharge = shippingCharge;
        return this;
    }

    @ApiModelProperty(value="The amount of the tax on the COD charge to be collected from the recipient for a COD order.")
    public Money getShippingCharge() {
        return this.shippingCharge;
    }

    public void setShippingCharge(Money shippingCharge) {
        this.shippingCharge = shippingCharge;
    }

    public CODSettings shippingChargeTax(Money shippingChargeTax) {
        this.shippingChargeTax = shippingChargeTax;
        return this;
    }

    @ApiModelProperty(value="The amount of the tax on the shipping charge to be collected from the recipient for a COD order.")
    public Money getShippingChargeTax() {
        return this.shippingChargeTax;
    }

    public void setShippingChargeTax(Money shippingChargeTax) {
        this.shippingChargeTax = shippingChargeTax;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CODSettings coDSettings = (CODSettings)o;
        return Objects.equals(this.isCodRequired, coDSettings.isCodRequired) && Objects.equals(this.codCharge, coDSettings.codCharge) && Objects.equals(this.codChargeTax, coDSettings.codChargeTax) && Objects.equals(this.shippingCharge, coDSettings.shippingCharge) && Objects.equals(this.shippingChargeTax, coDSettings.shippingChargeTax);
    }

    public int hashCode() {
        return Objects.hash(this.isCodRequired, this.codCharge, this.codChargeTax, this.shippingCharge, this.shippingChargeTax);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CODSettings {\n");
        sb.append("    isCodRequired: ").append(this.toIndentedString(this.isCodRequired)).append("\n");
        sb.append("    codCharge: ").append(this.toIndentedString(this.codCharge)).append("\n");
        sb.append("    codChargeTax: ").append(this.toIndentedString(this.codChargeTax)).append("\n");
        sb.append("    shippingCharge: ").append(this.toIndentedString(this.shippingCharge)).append("\n");
        sb.append("    shippingChargeTax: ").append(this.toIndentedString(this.shippingChargeTax)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

