/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentinbound;

import com.amazon.spapi.model.fulfillmentinbound.ShipmentType;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The shipping identifier, information about whether the shipment is by an Amazon-partnered carrier, and information about whether the shipment is Small Parcel or Less Than Truckload/Full Truckload (LTL/FTL).")
public class TransportHeader {
    @SerializedName(value="SellerId")
    private String sellerId = null;
    @SerializedName(value="ShipmentId")
    private String shipmentId = null;
    @SerializedName(value="IsPartnered")
    private Boolean isPartnered = null;
    @SerializedName(value="ShipmentType")
    private ShipmentType shipmentType = null;

    public TransportHeader sellerId(String sellerId) {
        this.sellerId = sellerId;
        return this;
    }

    @ApiModelProperty(required=true, value="The Amazon seller identifier.")
    public String getSellerId() {
        return this.sellerId;
    }

    public void setSellerId(String sellerId) {
        this.sellerId = sellerId;
    }

    public TransportHeader shipmentId(String shipmentId) {
        this.shipmentId = shipmentId;
        return this;
    }

    @ApiModelProperty(required=true, value="A shipment identifier originally returned by the createInboundShipmentPlan operation.")
    public String getShipmentId() {
        return this.shipmentId;
    }

    public void setShipmentId(String shipmentId) {
        this.shipmentId = shipmentId;
    }

    public TransportHeader isPartnered(Boolean isPartnered) {
        this.isPartnered = isPartnered;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether a putTransportDetails request is for a partnered carrier.  Possible values:  * true \u2013 Request is for an Amazon-partnered carrier.  * false \u2013 Request is for a non-Amazon-partnered carrier.")
    public Boolean isIsPartnered() {
        return this.isPartnered;
    }

    public void setIsPartnered(Boolean isPartnered) {
        this.isPartnered = isPartnered;
    }

    public TransportHeader shipmentType(ShipmentType shipmentType) {
        this.shipmentType = shipmentType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ShipmentType getShipmentType() {
        return this.shipmentType;
    }

    public void setShipmentType(ShipmentType shipmentType) {
        this.shipmentType = shipmentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransportHeader transportHeader = (TransportHeader)o;
        return Objects.equals(this.sellerId, transportHeader.sellerId) && Objects.equals(this.shipmentId, transportHeader.shipmentId) && Objects.equals(this.isPartnered, transportHeader.isPartnered) && Objects.equals((Object)this.shipmentType, (Object)transportHeader.shipmentType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sellerId, this.shipmentId, this.isPartnered, this.shipmentType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransportHeader {\n");
        sb.append("    sellerId: ").append(this.toIndentedString(this.sellerId)).append("\n");
        sb.append("    shipmentId: ").append(this.toIndentedString(this.shipmentId)).append("\n");
        sb.append("    isPartnered: ").append(this.toIndentedString(this.isPartnered)).append("\n");
        sb.append("    shipmentType: ").append(this.toIndentedString((Object)this.shipmentType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

