/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentinbound;

import com.amazon.spapi.model.fulfillmentinbound.Condition;
import com.amazon.spapi.model.fulfillmentinbound.PrepDetailsList;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Item information for creating an inbound shipment plan. Submitted with a call to the createInboundShipmentPlan operation.")
public class InboundShipmentPlanRequestItem {
    @SerializedName(value="SellerSKU")
    private String sellerSKU = null;
    @SerializedName(value="ASIN")
    private String ASIN = null;
    @SerializedName(value="Condition")
    private Condition condition = null;
    @SerializedName(value="Quantity")
    private Integer quantity = null;
    @SerializedName(value="QuantityInCase")
    private Integer quantityInCase = null;
    @SerializedName(value="PrepDetailsList")
    private PrepDetailsList prepDetailsList = null;

    public InboundShipmentPlanRequestItem sellerSKU(String sellerSKU) {
        this.sellerSKU = sellerSKU;
        return this;
    }

    @ApiModelProperty(required=true, value="The seller SKU of the item.")
    public String getSellerSKU() {
        return this.sellerSKU;
    }

    public void setSellerSKU(String sellerSKU) {
        this.sellerSKU = sellerSKU;
    }

    public InboundShipmentPlanRequestItem ASIN(String ASIN) {
        this.ASIN = ASIN;
        return this;
    }

    @ApiModelProperty(required=true, value="The Amazon Standard Identification Number (ASIN) of the item.")
    public String getASIN() {
        return this.ASIN;
    }

    public void setASIN(String ASIN) {
        this.ASIN = ASIN;
    }

    public InboundShipmentPlanRequestItem condition(Condition condition) {
        this.condition = condition;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public InboundShipmentPlanRequestItem quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public InboundShipmentPlanRequestItem quantityInCase(Integer quantityInCase) {
        this.quantityInCase = quantityInCase;
        return this;
    }

    @ApiModelProperty(value="The item quantity in each case, for case-packed items. Note that QuantityInCase multiplied by the number of cases in the inbound shipment equals Quantity. Also note that all of the boxes of an inbound shipment must either be case packed or individually packed. For that reason, when you submit the createInboundShipmentPlan operation, the value of QuantityInCase must be provided for every item in the shipment or for none of the items in the shipment.")
    public Integer getQuantityInCase() {
        return this.quantityInCase;
    }

    public void setQuantityInCase(Integer quantityInCase) {
        this.quantityInCase = quantityInCase;
    }

    public InboundShipmentPlanRequestItem prepDetailsList(PrepDetailsList prepDetailsList) {
        this.prepDetailsList = prepDetailsList;
        return this;
    }

    @ApiModelProperty(value="")
    public PrepDetailsList getPrepDetailsList() {
        return this.prepDetailsList;
    }

    public void setPrepDetailsList(PrepDetailsList prepDetailsList) {
        this.prepDetailsList = prepDetailsList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InboundShipmentPlanRequestItem inboundShipmentPlanRequestItem = (InboundShipmentPlanRequestItem)o;
        return Objects.equals(this.sellerSKU, inboundShipmentPlanRequestItem.sellerSKU) && Objects.equals(this.ASIN, inboundShipmentPlanRequestItem.ASIN) && Objects.equals((Object)this.condition, (Object)inboundShipmentPlanRequestItem.condition) && Objects.equals(this.quantity, inboundShipmentPlanRequestItem.quantity) && Objects.equals(this.quantityInCase, inboundShipmentPlanRequestItem.quantityInCase) && Objects.equals(this.prepDetailsList, inboundShipmentPlanRequestItem.prepDetailsList);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sellerSKU, this.ASIN, this.condition, this.quantity, this.quantityInCase, this.prepDetailsList});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InboundShipmentPlanRequestItem {\n");
        sb.append("    sellerSKU: ").append(this.toIndentedString(this.sellerSKU)).append("\n");
        sb.append("    ASIN: ").append(this.toIndentedString(this.ASIN)).append("\n");
        sb.append("    condition: ").append(this.toIndentedString((Object)this.condition)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    quantityInCase: ").append(this.toIndentedString(this.quantityInCase)).append("\n");
        sb.append("    prepDetailsList: ").append(this.toIndentedString(this.prepDetailsList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

