/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentinbound;

import com.amazon.spapi.model.fulfillmentinbound.Address;
import com.amazon.spapi.model.fulfillmentinbound.BoxContentsFeeDetails;
import com.amazon.spapi.model.fulfillmentinbound.InboundShipmentPlanItemList;
import com.amazon.spapi.model.fulfillmentinbound.LabelPrepType;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Inbound shipment information used to create an inbound shipment. Returned by the createInboundShipmentPlan operation.")
public class InboundShipmentPlan {
    @SerializedName(value="ShipmentId")
    private String shipmentId = null;
    @SerializedName(value="DestinationFulfillmentCenterId")
    private String destinationFulfillmentCenterId = null;
    @SerializedName(value="ShipToAddress")
    private Address shipToAddress = null;
    @SerializedName(value="LabelPrepType")
    private LabelPrepType labelPrepType = null;
    @SerializedName(value="Items")
    private InboundShipmentPlanItemList items = null;
    @SerializedName(value="EstimatedBoxContentsFee")
    private BoxContentsFeeDetails estimatedBoxContentsFee = null;

    public InboundShipmentPlan shipmentId(String shipmentId) {
        this.shipmentId = shipmentId;
        return this;
    }

    @ApiModelProperty(required=true, value="A shipment identifier originally returned by the createInboundShipmentPlan operation.")
    public String getShipmentId() {
        return this.shipmentId;
    }

    public void setShipmentId(String shipmentId) {
        this.shipmentId = shipmentId;
    }

    public InboundShipmentPlan destinationFulfillmentCenterId(String destinationFulfillmentCenterId) {
        this.destinationFulfillmentCenterId = destinationFulfillmentCenterId;
        return this;
    }

    @ApiModelProperty(required=true, value="An Amazon fulfillment center identifier created by Amazon.")
    public String getDestinationFulfillmentCenterId() {
        return this.destinationFulfillmentCenterId;
    }

    public void setDestinationFulfillmentCenterId(String destinationFulfillmentCenterId) {
        this.destinationFulfillmentCenterId = destinationFulfillmentCenterId;
    }

    public InboundShipmentPlan shipToAddress(Address shipToAddress) {
        this.shipToAddress = shipToAddress;
        return this;
    }

    @ApiModelProperty(required=true, value="The address of the Amazon fulfillment center to which to ship the items.")
    public Address getShipToAddress() {
        return this.shipToAddress;
    }

    public void setShipToAddress(Address shipToAddress) {
        this.shipToAddress = shipToAddress;
    }

    public InboundShipmentPlan labelPrepType(LabelPrepType labelPrepType) {
        this.labelPrepType = labelPrepType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public LabelPrepType getLabelPrepType() {
        return this.labelPrepType;
    }

    public void setLabelPrepType(LabelPrepType labelPrepType) {
        this.labelPrepType = labelPrepType;
    }

    public InboundShipmentPlan items(InboundShipmentPlanItemList items) {
        this.items = items;
        return this;
    }

    @ApiModelProperty(required=true, value="SKU and quantity information for the items in the shipment.")
    public InboundShipmentPlanItemList getItems() {
        return this.items;
    }

    public void setItems(InboundShipmentPlanItemList items) {
        this.items = items;
    }

    public InboundShipmentPlan estimatedBoxContentsFee(BoxContentsFeeDetails estimatedBoxContentsFee) {
        this.estimatedBoxContentsFee = estimatedBoxContentsFee;
        return this;
    }

    @ApiModelProperty(value="")
    public BoxContentsFeeDetails getEstimatedBoxContentsFee() {
        return this.estimatedBoxContentsFee;
    }

    public void setEstimatedBoxContentsFee(BoxContentsFeeDetails estimatedBoxContentsFee) {
        this.estimatedBoxContentsFee = estimatedBoxContentsFee;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InboundShipmentPlan inboundShipmentPlan = (InboundShipmentPlan)o;
        return Objects.equals(this.shipmentId, inboundShipmentPlan.shipmentId) && Objects.equals(this.destinationFulfillmentCenterId, inboundShipmentPlan.destinationFulfillmentCenterId) && Objects.equals(this.shipToAddress, inboundShipmentPlan.shipToAddress) && Objects.equals((Object)this.labelPrepType, (Object)inboundShipmentPlan.labelPrepType) && Objects.equals(this.items, inboundShipmentPlan.items) && Objects.equals(this.estimatedBoxContentsFee, inboundShipmentPlan.estimatedBoxContentsFee);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.shipmentId, this.destinationFulfillmentCenterId, this.shipToAddress, this.labelPrepType, this.items, this.estimatedBoxContentsFee});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InboundShipmentPlan {\n");
        sb.append("    shipmentId: ").append(this.toIndentedString(this.shipmentId)).append("\n");
        sb.append("    destinationFulfillmentCenterId: ").append(this.toIndentedString(this.destinationFulfillmentCenterId)).append("\n");
        sb.append("    shipToAddress: ").append(this.toIndentedString(this.shipToAddress)).append("\n");
        sb.append("    labelPrepType: ").append(this.toIndentedString((Object)this.labelPrepType)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    estimatedBoxContentsFee: ").append(this.toIndentedString(this.estimatedBoxContentsFee)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

