/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fulfillmentinbound;

import com.amazon.spapi.model.fulfillmentinbound.Address;
import com.amazon.spapi.model.fulfillmentinbound.IntendedBoxContentsSource;
import com.amazon.spapi.model.fulfillmentinbound.LabelPrepPreference;
import com.amazon.spapi.model.fulfillmentinbound.ShipmentStatus;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Inbound shipment information used to create and update inbound shipments.")
public class InboundShipmentHeader {
    @SerializedName(value="ShipmentName")
    private String shipmentName = null;
    @SerializedName(value="ShipFromAddress")
    private Address shipFromAddress = null;
    @SerializedName(value="DestinationFulfillmentCenterId")
    private String destinationFulfillmentCenterId = null;
    @SerializedName(value="AreCasesRequired")
    private Boolean areCasesRequired = null;
    @SerializedName(value="ShipmentStatus")
    private ShipmentStatus shipmentStatus = null;
    @SerializedName(value="LabelPrepPreference")
    private LabelPrepPreference labelPrepPreference = null;
    @SerializedName(value="IntendedBoxContentsSource")
    private IntendedBoxContentsSource intendedBoxContentsSource = null;

    public InboundShipmentHeader shipmentName(String shipmentName) {
        this.shipmentName = shipmentName;
        return this;
    }

    @ApiModelProperty(required=true, value="The name for the shipment. Use a naming convention that helps distinguish between shipments over time, such as the date the shipment was created.")
    public String getShipmentName() {
        return this.shipmentName;
    }

    public void setShipmentName(String shipmentName) {
        this.shipmentName = shipmentName;
    }

    public InboundShipmentHeader shipFromAddress(Address shipFromAddress) {
        this.shipFromAddress = shipFromAddress;
        return this;
    }

    @ApiModelProperty(required=true, value="The return address.")
    public Address getShipFromAddress() {
        return this.shipFromAddress;
    }

    public void setShipFromAddress(Address shipFromAddress) {
        this.shipFromAddress = shipFromAddress;
    }

    public InboundShipmentHeader destinationFulfillmentCenterId(String destinationFulfillmentCenterId) {
        this.destinationFulfillmentCenterId = destinationFulfillmentCenterId;
        return this;
    }

    @ApiModelProperty(required=true, value="The identifier for the fulfillment center to which the shipment will be shipped. Get this value from the InboundShipmentPlan object in the response returned by the createInboundShipmentPlan operation.")
    public String getDestinationFulfillmentCenterId() {
        return this.destinationFulfillmentCenterId;
    }

    public void setDestinationFulfillmentCenterId(String destinationFulfillmentCenterId) {
        this.destinationFulfillmentCenterId = destinationFulfillmentCenterId;
    }

    public InboundShipmentHeader areCasesRequired(Boolean areCasesRequired) {
        this.areCasesRequired = areCasesRequired;
        return this;
    }

    @ApiModelProperty(value="Indicates whether or not an inbound shipment contains case-packed boxes. Note: A shipment must contain either all case-packed boxes or all individually packed boxes.  Possible values:  true - All boxes in the shipment must be case packed.  false - All boxes in the shipment must be individually packed.  Note: If AreCasesRequired = true for an inbound shipment, then the value of QuantityInCase must be greater than zero for every item in the shipment. Otherwise the service returns an error.")
    public Boolean isAreCasesRequired() {
        return this.areCasesRequired;
    }

    public void setAreCasesRequired(Boolean areCasesRequired) {
        this.areCasesRequired = areCasesRequired;
    }

    public InboundShipmentHeader shipmentStatus(ShipmentStatus shipmentStatus) {
        this.shipmentStatus = shipmentStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ShipmentStatus getShipmentStatus() {
        return this.shipmentStatus;
    }

    public void setShipmentStatus(ShipmentStatus shipmentStatus) {
        this.shipmentStatus = shipmentStatus;
    }

    public InboundShipmentHeader labelPrepPreference(LabelPrepPreference labelPrepPreference) {
        this.labelPrepPreference = labelPrepPreference;
        return this;
    }

    @ApiModelProperty(required=true, value="The preference for label preparation for an inbound shipment.")
    public LabelPrepPreference getLabelPrepPreference() {
        return this.labelPrepPreference;
    }

    public void setLabelPrepPreference(LabelPrepPreference labelPrepPreference) {
        this.labelPrepPreference = labelPrepPreference;
    }

    public InboundShipmentHeader intendedBoxContentsSource(IntendedBoxContentsSource intendedBoxContentsSource) {
        this.intendedBoxContentsSource = intendedBoxContentsSource;
        return this;
    }

    @ApiModelProperty(value="")
    public IntendedBoxContentsSource getIntendedBoxContentsSource() {
        return this.intendedBoxContentsSource;
    }

    public void setIntendedBoxContentsSource(IntendedBoxContentsSource intendedBoxContentsSource) {
        this.intendedBoxContentsSource = intendedBoxContentsSource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InboundShipmentHeader inboundShipmentHeader = (InboundShipmentHeader)o;
        return Objects.equals(this.shipmentName, inboundShipmentHeader.shipmentName) && Objects.equals(this.shipFromAddress, inboundShipmentHeader.shipFromAddress) && Objects.equals(this.destinationFulfillmentCenterId, inboundShipmentHeader.destinationFulfillmentCenterId) && Objects.equals(this.areCasesRequired, inboundShipmentHeader.areCasesRequired) && Objects.equals((Object)this.shipmentStatus, (Object)inboundShipmentHeader.shipmentStatus) && Objects.equals((Object)this.labelPrepPreference, (Object)inboundShipmentHeader.labelPrepPreference) && Objects.equals((Object)this.intendedBoxContentsSource, (Object)inboundShipmentHeader.intendedBoxContentsSource);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.shipmentName, this.shipFromAddress, this.destinationFulfillmentCenterId, this.areCasesRequired, this.shipmentStatus, this.labelPrepPreference, this.intendedBoxContentsSource});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InboundShipmentHeader {\n");
        sb.append("    shipmentName: ").append(this.toIndentedString(this.shipmentName)).append("\n");
        sb.append("    shipFromAddress: ").append(this.toIndentedString(this.shipFromAddress)).append("\n");
        sb.append("    destinationFulfillmentCenterId: ").append(this.toIndentedString(this.destinationFulfillmentCenterId)).append("\n");
        sb.append("    areCasesRequired: ").append(this.toIndentedString(this.areCasesRequired)).append("\n");
        sb.append("    shipmentStatus: ").append(this.toIndentedString((Object)this.shipmentStatus)).append("\n");
        sb.append("    labelPrepPreference: ").append(this.toIndentedString((Object)this.labelPrepPreference)).append("\n");
        sb.append("    intendedBoxContentsSource: ").append(this.toIndentedString((Object)this.intendedBoxContentsSource)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

