/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.finances;

import com.amazon.spapi.model.finances.ChargeComponentList;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Information about the taxes withheld.")
public class TaxWithheldComponent {
    @SerializedName(value="TaxCollectionModel")
    private String taxCollectionModel = null;
    @SerializedName(value="TaxesWithheld")
    private ChargeComponentList taxesWithheld = null;

    public TaxWithheldComponent taxCollectionModel(String taxCollectionModel) {
        this.taxCollectionModel = taxCollectionModel;
        return this;
    }

    @ApiModelProperty(value="The tax collection model applied to the item.  Possible values:  * MarketplaceFacilitator - Tax is withheld and remitted to the taxing authority by Amazon on behalf of the seller.  * Standard - Tax is paid to the seller and not remitted to the taxing authority by Amazon.")
    public String getTaxCollectionModel() {
        return this.taxCollectionModel;
    }

    public void setTaxCollectionModel(String taxCollectionModel) {
        this.taxCollectionModel = taxCollectionModel;
    }

    public TaxWithheldComponent taxesWithheld(ChargeComponentList taxesWithheld) {
        this.taxesWithheld = taxesWithheld;
        return this;
    }

    @ApiModelProperty(value="A list of charges that represent the types and amounts of taxes withheld.")
    public ChargeComponentList getTaxesWithheld() {
        return this.taxesWithheld;
    }

    public void setTaxesWithheld(ChargeComponentList taxesWithheld) {
        this.taxesWithheld = taxesWithheld;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxWithheldComponent taxWithheldComponent = (TaxWithheldComponent)o;
        return Objects.equals(this.taxCollectionModel, taxWithheldComponent.taxCollectionModel) && Objects.equals(this.taxesWithheld, taxWithheldComponent.taxesWithheld);
    }

    public int hashCode() {
        return Objects.hash(this.taxCollectionModel, this.taxesWithheld);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxWithheldComponent {\n");
        sb.append("    taxCollectionModel: ").append(this.toIndentedString(this.taxCollectionModel)).append("\n");
        sb.append("    taxesWithheld: ").append(this.toIndentedString(this.taxesWithheld)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

