/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.finances;

import com.amazon.spapi.model.finances.FeeComponentList;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A service fee on the seller's account.")
public class ServiceFeeEvent {
    @SerializedName(value="AmazonOrderId")
    private String amazonOrderId = null;
    @SerializedName(value="FeeReason")
    private String feeReason = null;
    @SerializedName(value="FeeList")
    private FeeComponentList feeList = null;
    @SerializedName(value="SellerSKU")
    private String sellerSKU = null;
    @SerializedName(value="FnSKU")
    private String fnSKU = null;
    @SerializedName(value="FeeDescription")
    private String feeDescription = null;
    @SerializedName(value="ASIN")
    private String ASIN = null;

    public ServiceFeeEvent amazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
        return this;
    }

    @ApiModelProperty(value="An Amazon-defined identifier for an order.")
    public String getAmazonOrderId() {
        return this.amazonOrderId;
    }

    public void setAmazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
    }

    public ServiceFeeEvent feeReason(String feeReason) {
        this.feeReason = feeReason;
        return this;
    }

    @ApiModelProperty(value="A short description of the service fee reason.")
    public String getFeeReason() {
        return this.feeReason;
    }

    public void setFeeReason(String feeReason) {
        this.feeReason = feeReason;
    }

    public ServiceFeeEvent feeList(FeeComponentList feeList) {
        this.feeList = feeList;
        return this;
    }

    @ApiModelProperty(value="A list of fee components associated with the service fee.")
    public FeeComponentList getFeeList() {
        return this.feeList;
    }

    public void setFeeList(FeeComponentList feeList) {
        this.feeList = feeList;
    }

    public ServiceFeeEvent sellerSKU(String sellerSKU) {
        this.sellerSKU = sellerSKU;
        return this;
    }

    @ApiModelProperty(value="The seller SKU of the item. The seller SKU is qualified by the seller's seller ID, which is included with every call to the Selling Partner API.")
    public String getSellerSKU() {
        return this.sellerSKU;
    }

    public void setSellerSKU(String sellerSKU) {
        this.sellerSKU = sellerSKU;
    }

    public ServiceFeeEvent fnSKU(String fnSKU) {
        this.fnSKU = fnSKU;
        return this;
    }

    @ApiModelProperty(value="A unique identifier assigned by Amazon to products stored in and fulfilled from an Amazon fulfillment center.")
    public String getFnSKU() {
        return this.fnSKU;
    }

    public void setFnSKU(String fnSKU) {
        this.fnSKU = fnSKU;
    }

    public ServiceFeeEvent feeDescription(String feeDescription) {
        this.feeDescription = feeDescription;
        return this;
    }

    @ApiModelProperty(value="A short description of the service fee event.")
    public String getFeeDescription() {
        return this.feeDescription;
    }

    public void setFeeDescription(String feeDescription) {
        this.feeDescription = feeDescription;
    }

    public ServiceFeeEvent ASIN(String ASIN) {
        this.ASIN = ASIN;
        return this;
    }

    @ApiModelProperty(value="The Amazon Standard Identification Number (ASIN) of the item.")
    public String getASIN() {
        return this.ASIN;
    }

    public void setASIN(String ASIN) {
        this.ASIN = ASIN;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceFeeEvent serviceFeeEvent = (ServiceFeeEvent)o;
        return Objects.equals(this.amazonOrderId, serviceFeeEvent.amazonOrderId) && Objects.equals(this.feeReason, serviceFeeEvent.feeReason) && Objects.equals(this.feeList, serviceFeeEvent.feeList) && Objects.equals(this.sellerSKU, serviceFeeEvent.sellerSKU) && Objects.equals(this.fnSKU, serviceFeeEvent.fnSKU) && Objects.equals(this.feeDescription, serviceFeeEvent.feeDescription) && Objects.equals(this.ASIN, serviceFeeEvent.ASIN);
    }

    public int hashCode() {
        return Objects.hash(this.amazonOrderId, this.feeReason, this.feeList, this.sellerSKU, this.fnSKU, this.feeDescription, this.ASIN);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceFeeEvent {\n");
        sb.append("    amazonOrderId: ").append(this.toIndentedString(this.amazonOrderId)).append("\n");
        sb.append("    feeReason: ").append(this.toIndentedString(this.feeReason)).append("\n");
        sb.append("    feeList: ").append(this.toIndentedString(this.feeList)).append("\n");
        sb.append("    sellerSKU: ").append(this.toIndentedString(this.sellerSKU)).append("\n");
        sb.append("    fnSKU: ").append(this.toIndentedString(this.fnSKU)).append("\n");
        sb.append("    feeDescription: ").append(this.toIndentedString(this.feeDescription)).append("\n");
        sb.append("    ASIN: ").append(this.toIndentedString(this.ASIN)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

