/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.finances;

import com.amazon.spapi.model.finances.ChargeComponentList;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="An item from a SAFE-T claim reimbursement.")
public class SAFETReimbursementItem {
    @SerializedName(value="itemChargeList")
    private ChargeComponentList itemChargeList = null;
    @SerializedName(value="productDescription")
    private String productDescription = null;
    @SerializedName(value="quantity")
    private String quantity = null;

    public SAFETReimbursementItem itemChargeList(ChargeComponentList itemChargeList) {
        this.itemChargeList = itemChargeList;
        return this;
    }

    @ApiModelProperty(value="A list of charges associated with the item.")
    public ChargeComponentList getItemChargeList() {
        return this.itemChargeList;
    }

    public void setItemChargeList(ChargeComponentList itemChargeList) {
        this.itemChargeList = itemChargeList;
    }

    public SAFETReimbursementItem productDescription(String productDescription) {
        this.productDescription = productDescription;
        return this;
    }

    @ApiModelProperty(value="The description of the item as shown on the product detail page on the retail website.")
    public String getProductDescription() {
        return this.productDescription;
    }

    public void setProductDescription(String productDescription) {
        this.productDescription = productDescription;
    }

    public SAFETReimbursementItem quantity(String quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(value="The number of units of the item being reimbursed.")
    public String getQuantity() {
        return this.quantity;
    }

    public void setQuantity(String quantity) {
        this.quantity = quantity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SAFETReimbursementItem saFETReimbursementItem = (SAFETReimbursementItem)o;
        return Objects.equals(this.itemChargeList, saFETReimbursementItem.itemChargeList) && Objects.equals(this.productDescription, saFETReimbursementItem.productDescription) && Objects.equals(this.quantity, saFETReimbursementItem.quantity);
    }

    public int hashCode() {
        return Objects.hash(this.itemChargeList, this.productDescription, this.quantity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SAFETReimbursementItem {\n");
        sb.append("    itemChargeList: ").append(this.toIndentedString(this.itemChargeList)).append("\n");
        sb.append("    productDescription: ").append(this.toIndentedString(this.productDescription)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

