/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.finances;

import com.amazon.spapi.model.finances.RemovalShipmentItemList;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A removal shipment event for a removal order.")
public class RemovalShipmentEvent {
    @SerializedName(value="PostedDate")
    private String postedDate = null;
    @SerializedName(value="OrderId")
    private String orderId = null;
    @SerializedName(value="TransactionType")
    private String transactionType = null;
    @SerializedName(value="RemovalShipmentItemList")
    private RemovalShipmentItemList removalShipmentItemList = null;

    public RemovalShipmentEvent postedDate(String postedDate) {
        this.postedDate = postedDate;
        return this;
    }

    @ApiModelProperty(value="The date and time when the financial event was posted.")
    public String getPostedDate() {
        return this.postedDate;
    }

    public void setPostedDate(String postedDate) {
        this.postedDate = postedDate;
    }

    public RemovalShipmentEvent orderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    @ApiModelProperty(value="The identifier for the removal shipment order.")
    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public RemovalShipmentEvent transactionType(String transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    @ApiModelProperty(value="The type of removal order.  Possible values:  * WHOLESALE_LIQUIDATION")
    public String getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public RemovalShipmentEvent removalShipmentItemList(RemovalShipmentItemList removalShipmentItemList) {
        this.removalShipmentItemList = removalShipmentItemList;
        return this;
    }

    @ApiModelProperty(value="A list of removal shipment items.")
    public RemovalShipmentItemList getRemovalShipmentItemList() {
        return this.removalShipmentItemList;
    }

    public void setRemovalShipmentItemList(RemovalShipmentItemList removalShipmentItemList) {
        this.removalShipmentItemList = removalShipmentItemList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemovalShipmentEvent removalShipmentEvent = (RemovalShipmentEvent)o;
        return Objects.equals(this.postedDate, removalShipmentEvent.postedDate) && Objects.equals(this.orderId, removalShipmentEvent.orderId) && Objects.equals(this.transactionType, removalShipmentEvent.transactionType) && Objects.equals(this.removalShipmentItemList, removalShipmentEvent.removalShipmentItemList);
    }

    public int hashCode() {
        return Objects.hash(this.postedDate, this.orderId, this.transactionType, this.removalShipmentItemList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RemovalShipmentEvent {\n");
        sb.append("    postedDate: ").append(this.toIndentedString(this.postedDate)).append("\n");
        sb.append("    orderId: ").append(this.toIndentedString(this.orderId)).append("\n");
        sb.append("    transactionType: ").append(this.toIndentedString(this.transactionType)).append("\n");
        sb.append("    removalShipmentItemList: ").append(this.toIndentedString(this.removalShipmentItemList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

