/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.finances;

import com.amazon.spapi.model.finances.ChargeComponent;
import com.amazon.spapi.model.finances.FeeComponentList;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="An event related to the seller's Pay with Amazon account.")
public class PayWithAmazonEvent {
    @SerializedName(value="SellerOrderId")
    private String sellerOrderId = null;
    @SerializedName(value="TransactionPostedDate")
    private String transactionPostedDate = null;
    @SerializedName(value="BusinessObjectType")
    private String businessObjectType = null;
    @SerializedName(value="SalesChannel")
    private String salesChannel = null;
    @SerializedName(value="Charge")
    private ChargeComponent charge = null;
    @SerializedName(value="FeeList")
    private FeeComponentList feeList = null;
    @SerializedName(value="PaymentAmountType")
    private String paymentAmountType = null;
    @SerializedName(value="AmountDescription")
    private String amountDescription = null;
    @SerializedName(value="FulfillmentChannel")
    private String fulfillmentChannel = null;
    @SerializedName(value="StoreName")
    private String storeName = null;

    public PayWithAmazonEvent sellerOrderId(String sellerOrderId) {
        this.sellerOrderId = sellerOrderId;
        return this;
    }

    @ApiModelProperty(value="An order identifier that is specified by the seller.")
    public String getSellerOrderId() {
        return this.sellerOrderId;
    }

    public void setSellerOrderId(String sellerOrderId) {
        this.sellerOrderId = sellerOrderId;
    }

    public PayWithAmazonEvent transactionPostedDate(String transactionPostedDate) {
        this.transactionPostedDate = transactionPostedDate;
        return this;
    }

    @ApiModelProperty(value="The date and time when the payment transaction is posted. In ISO 8601 date time format.")
    public String getTransactionPostedDate() {
        return this.transactionPostedDate;
    }

    public void setTransactionPostedDate(String transactionPostedDate) {
        this.transactionPostedDate = transactionPostedDate;
    }

    public PayWithAmazonEvent businessObjectType(String businessObjectType) {
        this.businessObjectType = businessObjectType;
        return this;
    }

    @ApiModelProperty(value="The type of business object.")
    public String getBusinessObjectType() {
        return this.businessObjectType;
    }

    public void setBusinessObjectType(String businessObjectType) {
        this.businessObjectType = businessObjectType;
    }

    public PayWithAmazonEvent salesChannel(String salesChannel) {
        this.salesChannel = salesChannel;
        return this;
    }

    @ApiModelProperty(value="The sales channel for the transaction.")
    public String getSalesChannel() {
        return this.salesChannel;
    }

    public void setSalesChannel(String salesChannel) {
        this.salesChannel = salesChannel;
    }

    public PayWithAmazonEvent charge(ChargeComponent charge) {
        this.charge = charge;
        return this;
    }

    @ApiModelProperty(value="The charge associated with the event.")
    public ChargeComponent getCharge() {
        return this.charge;
    }

    public void setCharge(ChargeComponent charge) {
        this.charge = charge;
    }

    public PayWithAmazonEvent feeList(FeeComponentList feeList) {
        this.feeList = feeList;
        return this;
    }

    @ApiModelProperty(value="A list of fees associated with the event.")
    public FeeComponentList getFeeList() {
        return this.feeList;
    }

    public void setFeeList(FeeComponentList feeList) {
        this.feeList = feeList;
    }

    public PayWithAmazonEvent paymentAmountType(String paymentAmountType) {
        this.paymentAmountType = paymentAmountType;
        return this;
    }

    @ApiModelProperty(value="The type of payment.  Possible values:  * Sales")
    public String getPaymentAmountType() {
        return this.paymentAmountType;
    }

    public void setPaymentAmountType(String paymentAmountType) {
        this.paymentAmountType = paymentAmountType;
    }

    public PayWithAmazonEvent amountDescription(String amountDescription) {
        this.amountDescription = amountDescription;
        return this;
    }

    @ApiModelProperty(value="A short description of this payment event.")
    public String getAmountDescription() {
        return this.amountDescription;
    }

    public void setAmountDescription(String amountDescription) {
        this.amountDescription = amountDescription;
    }

    public PayWithAmazonEvent fulfillmentChannel(String fulfillmentChannel) {
        this.fulfillmentChannel = fulfillmentChannel;
        return this;
    }

    @ApiModelProperty(value="The fulfillment channel.  Possible values:  * AFN - Amazon Fulfillment Network (Fulfillment by Amazon)  * MFN - Merchant Fulfillment Network (self-fulfilled)")
    public String getFulfillmentChannel() {
        return this.fulfillmentChannel;
    }

    public void setFulfillmentChannel(String fulfillmentChannel) {
        this.fulfillmentChannel = fulfillmentChannel;
    }

    public PayWithAmazonEvent storeName(String storeName) {
        this.storeName = storeName;
        return this;
    }

    @ApiModelProperty(value="The store name where the event occurred.")
    public String getStoreName() {
        return this.storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayWithAmazonEvent payWithAmazonEvent = (PayWithAmazonEvent)o;
        return Objects.equals(this.sellerOrderId, payWithAmazonEvent.sellerOrderId) && Objects.equals(this.transactionPostedDate, payWithAmazonEvent.transactionPostedDate) && Objects.equals(this.businessObjectType, payWithAmazonEvent.businessObjectType) && Objects.equals(this.salesChannel, payWithAmazonEvent.salesChannel) && Objects.equals(this.charge, payWithAmazonEvent.charge) && Objects.equals(this.feeList, payWithAmazonEvent.feeList) && Objects.equals(this.paymentAmountType, payWithAmazonEvent.paymentAmountType) && Objects.equals(this.amountDescription, payWithAmazonEvent.amountDescription) && Objects.equals(this.fulfillmentChannel, payWithAmazonEvent.fulfillmentChannel) && Objects.equals(this.storeName, payWithAmazonEvent.storeName);
    }

    public int hashCode() {
        return Objects.hash(this.sellerOrderId, this.transactionPostedDate, this.businessObjectType, this.salesChannel, this.charge, this.feeList, this.paymentAmountType, this.amountDescription, this.fulfillmentChannel, this.storeName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayWithAmazonEvent {\n");
        sb.append("    sellerOrderId: ").append(this.toIndentedString(this.sellerOrderId)).append("\n");
        sb.append("    transactionPostedDate: ").append(this.toIndentedString(this.transactionPostedDate)).append("\n");
        sb.append("    businessObjectType: ").append(this.toIndentedString(this.businessObjectType)).append("\n");
        sb.append("    salesChannel: ").append(this.toIndentedString(this.salesChannel)).append("\n");
        sb.append("    charge: ").append(this.toIndentedString(this.charge)).append("\n");
        sb.append("    feeList: ").append(this.toIndentedString(this.feeList)).append("\n");
        sb.append("    paymentAmountType: ").append(this.toIndentedString(this.paymentAmountType)).append("\n");
        sb.append("    amountDescription: ").append(this.toIndentedString(this.amountDescription)).append("\n");
        sb.append("    fulfillmentChannel: ").append(this.toIndentedString(this.fulfillmentChannel)).append("\n");
        sb.append("    storeName: ").append(this.toIndentedString(this.storeName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

