/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.finances;

import com.amazon.spapi.model.finances.Currency;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A network commingling transaction event.")
public class NetworkComminglingTransactionEvent {
    @SerializedName(value="TransactionType")
    private String transactionType = null;
    @SerializedName(value="PostedDate")
    private String postedDate = null;
    @SerializedName(value="NetCoTransactionID")
    private String netCoTransactionID = null;
    @SerializedName(value="SwapReason")
    private String swapReason = null;
    @SerializedName(value="ASIN")
    private String ASIN = null;
    @SerializedName(value="MarketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="TaxExclusiveAmount")
    private Currency taxExclusiveAmount = null;
    @SerializedName(value="TaxAmount")
    private Currency taxAmount = null;

    public NetworkComminglingTransactionEvent transactionType(String transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    @ApiModelProperty(value="The type of network item swap.  Possible values:  * NetCo - A Fulfillment by Amazon inventory pooling transaction. Available only in the India marketplace.  * ComminglingVAT - A commingling VAT transaction. Available only in the UK, Spain, France, Germany, and Italy marketplaces.")
    public String getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public NetworkComminglingTransactionEvent postedDate(String postedDate) {
        this.postedDate = postedDate;
        return this;
    }

    @ApiModelProperty(value="The date and time when the financial event was posted.")
    public String getPostedDate() {
        return this.postedDate;
    }

    public void setPostedDate(String postedDate) {
        this.postedDate = postedDate;
    }

    public NetworkComminglingTransactionEvent netCoTransactionID(String netCoTransactionID) {
        this.netCoTransactionID = netCoTransactionID;
        return this;
    }

    @ApiModelProperty(value="The identifier for the network item swap.")
    public String getNetCoTransactionID() {
        return this.netCoTransactionID;
    }

    public void setNetCoTransactionID(String netCoTransactionID) {
        this.netCoTransactionID = netCoTransactionID;
    }

    public NetworkComminglingTransactionEvent swapReason(String swapReason) {
        this.swapReason = swapReason;
        return this;
    }

    @ApiModelProperty(value="The reason for the network item swap.")
    public String getSwapReason() {
        return this.swapReason;
    }

    public void setSwapReason(String swapReason) {
        this.swapReason = swapReason;
    }

    public NetworkComminglingTransactionEvent ASIN(String ASIN) {
        this.ASIN = ASIN;
        return this;
    }

    @ApiModelProperty(value="The Amazon Standard Identification Number (ASIN) of the swapped item.")
    public String getASIN() {
        return this.ASIN;
    }

    public void setASIN(String ASIN) {
        this.ASIN = ASIN;
    }

    public NetworkComminglingTransactionEvent marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @ApiModelProperty(value="The marketplace in which the event took place.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public NetworkComminglingTransactionEvent taxExclusiveAmount(Currency taxExclusiveAmount) {
        this.taxExclusiveAmount = taxExclusiveAmount;
        return this;
    }

    @ApiModelProperty(value="The price of the swapped item minus TaxAmount.")
    public Currency getTaxExclusiveAmount() {
        return this.taxExclusiveAmount;
    }

    public void setTaxExclusiveAmount(Currency taxExclusiveAmount) {
        this.taxExclusiveAmount = taxExclusiveAmount;
    }

    public NetworkComminglingTransactionEvent taxAmount(Currency taxAmount) {
        this.taxAmount = taxAmount;
        return this;
    }

    @ApiModelProperty(value="The tax on the network item swap paid by the seller.")
    public Currency getTaxAmount() {
        return this.taxAmount;
    }

    public void setTaxAmount(Currency taxAmount) {
        this.taxAmount = taxAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkComminglingTransactionEvent networkComminglingTransactionEvent = (NetworkComminglingTransactionEvent)o;
        return Objects.equals(this.transactionType, networkComminglingTransactionEvent.transactionType) && Objects.equals(this.postedDate, networkComminglingTransactionEvent.postedDate) && Objects.equals(this.netCoTransactionID, networkComminglingTransactionEvent.netCoTransactionID) && Objects.equals(this.swapReason, networkComminglingTransactionEvent.swapReason) && Objects.equals(this.ASIN, networkComminglingTransactionEvent.ASIN) && Objects.equals(this.marketplaceId, networkComminglingTransactionEvent.marketplaceId) && Objects.equals(this.taxExclusiveAmount, networkComminglingTransactionEvent.taxExclusiveAmount) && Objects.equals(this.taxAmount, networkComminglingTransactionEvent.taxAmount);
    }

    public int hashCode() {
        return Objects.hash(this.transactionType, this.postedDate, this.netCoTransactionID, this.swapReason, this.ASIN, this.marketplaceId, this.taxExclusiveAmount, this.taxAmount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NetworkComminglingTransactionEvent {\n");
        sb.append("    transactionType: ").append(this.toIndentedString(this.transactionType)).append("\n");
        sb.append("    postedDate: ").append(this.toIndentedString(this.postedDate)).append("\n");
        sb.append("    netCoTransactionID: ").append(this.toIndentedString(this.netCoTransactionID)).append("\n");
        sb.append("    swapReason: ").append(this.toIndentedString(this.swapReason)).append("\n");
        sb.append("    ASIN: ").append(this.toIndentedString(this.ASIN)).append("\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    taxExclusiveAmount: ").append(this.toIndentedString(this.taxExclusiveAmount)).append("\n");
        sb.append("    taxAmount: ").append(this.toIndentedString(this.taxAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

