/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.finances;

import com.amazon.spapi.model.finances.Currency;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Information related to a financial event group.")
public class FinancialEventGroup {
    @SerializedName(value="FinancialEventGroupId")
    private String financialEventGroupId = null;
    @SerializedName(value="ProcessingStatus")
    private String processingStatus = null;
    @SerializedName(value="FundTransferStatus")
    private String fundTransferStatus = null;
    @SerializedName(value="OriginalTotal")
    private Currency originalTotal = null;
    @SerializedName(value="ConvertedTotal")
    private Currency convertedTotal = null;
    @SerializedName(value="FundTransferDate")
    private String fundTransferDate = null;
    @SerializedName(value="TraceId")
    private String traceId = null;
    @SerializedName(value="AccountTail")
    private String accountTail = null;
    @SerializedName(value="BeginningBalance")
    private Currency beginningBalance = null;
    @SerializedName(value="FinancialEventGroupStart")
    private String financialEventGroupStart = null;
    @SerializedName(value="FinancialEventGroupEnd")
    private String financialEventGroupEnd = null;

    public FinancialEventGroup financialEventGroupId(String financialEventGroupId) {
        this.financialEventGroupId = financialEventGroupId;
        return this;
    }

    @ApiModelProperty(value="A unique identifier for the financial event group.")
    public String getFinancialEventGroupId() {
        return this.financialEventGroupId;
    }

    public void setFinancialEventGroupId(String financialEventGroupId) {
        this.financialEventGroupId = financialEventGroupId;
    }

    public FinancialEventGroup processingStatus(String processingStatus) {
        this.processingStatus = processingStatus;
        return this;
    }

    @ApiModelProperty(value="The processing status of the financial event group indicates whether the balance of the financial event group is settled.  Possible values:  * Open  * Closed")
    public String getProcessingStatus() {
        return this.processingStatus;
    }

    public void setProcessingStatus(String processingStatus) {
        this.processingStatus = processingStatus;
    }

    public FinancialEventGroup fundTransferStatus(String fundTransferStatus) {
        this.fundTransferStatus = fundTransferStatus;
        return this;
    }

    @ApiModelProperty(value="The status of the fund transfer.")
    public String getFundTransferStatus() {
        return this.fundTransferStatus;
    }

    public void setFundTransferStatus(String fundTransferStatus) {
        this.fundTransferStatus = fundTransferStatus;
    }

    public FinancialEventGroup originalTotal(Currency originalTotal) {
        this.originalTotal = originalTotal;
        return this;
    }

    @ApiModelProperty(value="The total amount in the currency of the marketplace in which the transactions occurred.")
    public Currency getOriginalTotal() {
        return this.originalTotal;
    }

    public void setOriginalTotal(Currency originalTotal) {
        this.originalTotal = originalTotal;
    }

    public FinancialEventGroup convertedTotal(Currency convertedTotal) {
        this.convertedTotal = convertedTotal;
        return this;
    }

    @ApiModelProperty(value="The total amount in the currency of the marketplace in which the funds were disbursed.")
    public Currency getConvertedTotal() {
        return this.convertedTotal;
    }

    public void setConvertedTotal(Currency convertedTotal) {
        this.convertedTotal = convertedTotal;
    }

    public FinancialEventGroup fundTransferDate(String fundTransferDate) {
        this.fundTransferDate = fundTransferDate;
        return this;
    }

    @ApiModelProperty(value="The date and time when the disbursement or charge was initiated. Only present for closed settlements. In ISO 8601 date time format.")
    public String getFundTransferDate() {
        return this.fundTransferDate;
    }

    public void setFundTransferDate(String fundTransferDate) {
        this.fundTransferDate = fundTransferDate;
    }

    public FinancialEventGroup traceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    @ApiModelProperty(value="The trace identifier used by sellers to look up transactions externally.")
    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public FinancialEventGroup accountTail(String accountTail) {
        this.accountTail = accountTail;
        return this;
    }

    @ApiModelProperty(value="The account tail of the payment instrument.")
    public String getAccountTail() {
        return this.accountTail;
    }

    public void setAccountTail(String accountTail) {
        this.accountTail = accountTail;
    }

    public FinancialEventGroup beginningBalance(Currency beginningBalance) {
        this.beginningBalance = beginningBalance;
        return this;
    }

    @ApiModelProperty(value="The balance at the beginning of the settlement period.")
    public Currency getBeginningBalance() {
        return this.beginningBalance;
    }

    public void setBeginningBalance(Currency beginningBalance) {
        this.beginningBalance = beginningBalance;
    }

    public FinancialEventGroup financialEventGroupStart(String financialEventGroupStart) {
        this.financialEventGroupStart = financialEventGroupStart;
        return this;
    }

    @ApiModelProperty(value="The date and time at which the financial event group is opened. In ISO 8601 date time format.")
    public String getFinancialEventGroupStart() {
        return this.financialEventGroupStart;
    }

    public void setFinancialEventGroupStart(String financialEventGroupStart) {
        this.financialEventGroupStart = financialEventGroupStart;
    }

    public FinancialEventGroup financialEventGroupEnd(String financialEventGroupEnd) {
        this.financialEventGroupEnd = financialEventGroupEnd;
        return this;
    }

    @ApiModelProperty(value="The date and time at which the financial event group is closed. In ISO 8601 date time format.")
    public String getFinancialEventGroupEnd() {
        return this.financialEventGroupEnd;
    }

    public void setFinancialEventGroupEnd(String financialEventGroupEnd) {
        this.financialEventGroupEnd = financialEventGroupEnd;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FinancialEventGroup financialEventGroup = (FinancialEventGroup)o;
        return Objects.equals(this.financialEventGroupId, financialEventGroup.financialEventGroupId) && Objects.equals(this.processingStatus, financialEventGroup.processingStatus) && Objects.equals(this.fundTransferStatus, financialEventGroup.fundTransferStatus) && Objects.equals(this.originalTotal, financialEventGroup.originalTotal) && Objects.equals(this.convertedTotal, financialEventGroup.convertedTotal) && Objects.equals(this.fundTransferDate, financialEventGroup.fundTransferDate) && Objects.equals(this.traceId, financialEventGroup.traceId) && Objects.equals(this.accountTail, financialEventGroup.accountTail) && Objects.equals(this.beginningBalance, financialEventGroup.beginningBalance) && Objects.equals(this.financialEventGroupStart, financialEventGroup.financialEventGroupStart) && Objects.equals(this.financialEventGroupEnd, financialEventGroup.financialEventGroupEnd);
    }

    public int hashCode() {
        return Objects.hash(this.financialEventGroupId, this.processingStatus, this.fundTransferStatus, this.originalTotal, this.convertedTotal, this.fundTransferDate, this.traceId, this.accountTail, this.beginningBalance, this.financialEventGroupStart, this.financialEventGroupEnd);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FinancialEventGroup {\n");
        sb.append("    financialEventGroupId: ").append(this.toIndentedString(this.financialEventGroupId)).append("\n");
        sb.append("    processingStatus: ").append(this.toIndentedString(this.processingStatus)).append("\n");
        sb.append("    fundTransferStatus: ").append(this.toIndentedString(this.fundTransferStatus)).append("\n");
        sb.append("    originalTotal: ").append(this.toIndentedString(this.originalTotal)).append("\n");
        sb.append("    convertedTotal: ").append(this.toIndentedString(this.convertedTotal)).append("\n");
        sb.append("    fundTransferDate: ").append(this.toIndentedString(this.fundTransferDate)).append("\n");
        sb.append("    traceId: ").append(this.toIndentedString(this.traceId)).append("\n");
        sb.append("    accountTail: ").append(this.toIndentedString(this.accountTail)).append("\n");
        sb.append("    beginningBalance: ").append(this.toIndentedString(this.beginningBalance)).append("\n");
        sb.append("    financialEventGroupStart: ").append(this.toIndentedString(this.financialEventGroupStart)).append("\n");
        sb.append("    financialEventGroupEnd: ").append(this.toIndentedString(this.financialEventGroupEnd)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

