/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.finances;

import com.amazon.spapi.model.finances.Currency;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A payment instrument.")
public class ChargeInstrument {
    @SerializedName(value="Description")
    private String description = null;
    @SerializedName(value="Tail")
    private String tail = null;
    @SerializedName(value="Amount")
    private Currency amount = null;

    public ChargeInstrument description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="A short description of the charge instrument.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ChargeInstrument tail(String tail) {
        this.tail = tail;
        return this;
    }

    @ApiModelProperty(value="The account tail (trailing digits) of the charge instrument.")
    public String getTail() {
        return this.tail;
    }

    public void setTail(String tail) {
        this.tail = tail;
    }

    public ChargeInstrument amount(Currency amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="The amount charged to this charge instrument.")
    public Currency getAmount() {
        return this.amount;
    }

    public void setAmount(Currency amount) {
        this.amount = amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChargeInstrument chargeInstrument = (ChargeInstrument)o;
        return Objects.equals(this.description, chargeInstrument.description) && Objects.equals(this.tail, chargeInstrument.tail) && Objects.equals(this.amount, chargeInstrument.amount);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.tail, this.amount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChargeInstrument {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    tail: ").append(this.toIndentedString(this.tail)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

