/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.finances;

import com.amazon.spapi.model.finances.Currency;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="An expense related to an affordability promotion.")
public class AffordabilityExpenseEvent {
    @SerializedName(value="AmazonOrderId")
    private String amazonOrderId = null;
    @SerializedName(value="PostedDate")
    private String postedDate = null;
    @SerializedName(value="MarketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="TransactionType")
    private String transactionType = null;
    @SerializedName(value="BaseExpense")
    private Currency baseExpense = null;
    @SerializedName(value="TaxTypeCGST")
    private Currency taxTypeCGST = null;
    @SerializedName(value="TaxTypeSGST")
    private Currency taxTypeSGST = null;
    @SerializedName(value="TaxTypeIGST")
    private Currency taxTypeIGST = null;
    @SerializedName(value="TotalExpense")
    private Currency totalExpense = null;

    public AffordabilityExpenseEvent amazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
        return this;
    }

    @ApiModelProperty(value="An Amazon-defined identifier for an order.")
    public String getAmazonOrderId() {
        return this.amazonOrderId;
    }

    public void setAmazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
    }

    public AffordabilityExpenseEvent postedDate(String postedDate) {
        this.postedDate = postedDate;
        return this;
    }

    @ApiModelProperty(value="The date and time when the financial event was created.")
    public String getPostedDate() {
        return this.postedDate;
    }

    public void setPostedDate(String postedDate) {
        this.postedDate = postedDate;
    }

    public AffordabilityExpenseEvent marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @ApiModelProperty(value="An encrypted, Amazon-defined marketplace identifier.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public AffordabilityExpenseEvent transactionType(String transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    @ApiModelProperty(value="Indicates the type of transaction.   Possible values:  * Charge - For an affordability promotion expense.  * Refund - For an affordability promotion expense reversal.")
    public String getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public AffordabilityExpenseEvent baseExpense(Currency baseExpense) {
        this.baseExpense = baseExpense;
        return this;
    }

    @ApiModelProperty(value="The amount charged for clicks incurred under the Sponsored Products program.")
    public Currency getBaseExpense() {
        return this.baseExpense;
    }

    public void setBaseExpense(Currency baseExpense) {
        this.baseExpense = baseExpense;
    }

    public AffordabilityExpenseEvent taxTypeCGST(Currency taxTypeCGST) {
        this.taxTypeCGST = taxTypeCGST;
        return this;
    }

    @ApiModelProperty(required=true, value="Central Goods and Service Tax, charged and collected by the central government.")
    public Currency getTaxTypeCGST() {
        return this.taxTypeCGST;
    }

    public void setTaxTypeCGST(Currency taxTypeCGST) {
        this.taxTypeCGST = taxTypeCGST;
    }

    public AffordabilityExpenseEvent taxTypeSGST(Currency taxTypeSGST) {
        this.taxTypeSGST = taxTypeSGST;
        return this;
    }

    @ApiModelProperty(required=true, value="State Goods and Service Tax, charged and collected by the state government.")
    public Currency getTaxTypeSGST() {
        return this.taxTypeSGST;
    }

    public void setTaxTypeSGST(Currency taxTypeSGST) {
        this.taxTypeSGST = taxTypeSGST;
    }

    public AffordabilityExpenseEvent taxTypeIGST(Currency taxTypeIGST) {
        this.taxTypeIGST = taxTypeIGST;
        return this;
    }

    @ApiModelProperty(required=true, value="Integrated Goods and Service Tax, charged and collected by the central government.")
    public Currency getTaxTypeIGST() {
        return this.taxTypeIGST;
    }

    public void setTaxTypeIGST(Currency taxTypeIGST) {
        this.taxTypeIGST = taxTypeIGST;
    }

    public AffordabilityExpenseEvent totalExpense(Currency totalExpense) {
        this.totalExpense = totalExpense;
        return this;
    }

    @ApiModelProperty(value="The total amount charged to the seller. TotalExpense = BaseExpense + TaxTypeIGST + TaxTypeCGST + TaxTypeSGST.")
    public Currency getTotalExpense() {
        return this.totalExpense;
    }

    public void setTotalExpense(Currency totalExpense) {
        this.totalExpense = totalExpense;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AffordabilityExpenseEvent affordabilityExpenseEvent = (AffordabilityExpenseEvent)o;
        return Objects.equals(this.amazonOrderId, affordabilityExpenseEvent.amazonOrderId) && Objects.equals(this.postedDate, affordabilityExpenseEvent.postedDate) && Objects.equals(this.marketplaceId, affordabilityExpenseEvent.marketplaceId) && Objects.equals(this.transactionType, affordabilityExpenseEvent.transactionType) && Objects.equals(this.baseExpense, affordabilityExpenseEvent.baseExpense) && Objects.equals(this.taxTypeCGST, affordabilityExpenseEvent.taxTypeCGST) && Objects.equals(this.taxTypeSGST, affordabilityExpenseEvent.taxTypeSGST) && Objects.equals(this.taxTypeIGST, affordabilityExpenseEvent.taxTypeIGST) && Objects.equals(this.totalExpense, affordabilityExpenseEvent.totalExpense);
    }

    public int hashCode() {
        return Objects.hash(this.amazonOrderId, this.postedDate, this.marketplaceId, this.transactionType, this.baseExpense, this.taxTypeCGST, this.taxTypeSGST, this.taxTypeIGST, this.totalExpense);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AffordabilityExpenseEvent {\n");
        sb.append("    amazonOrderId: ").append(this.toIndentedString(this.amazonOrderId)).append("\n");
        sb.append("    postedDate: ").append(this.toIndentedString(this.postedDate)).append("\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    transactionType: ").append(this.toIndentedString(this.transactionType)).append("\n");
        sb.append("    baseExpense: ").append(this.toIndentedString(this.baseExpense)).append("\n");
        sb.append("    taxTypeCGST: ").append(this.toIndentedString(this.taxTypeCGST)).append("\n");
        sb.append("    taxTypeSGST: ").append(this.toIndentedString(this.taxTypeSGST)).append("\n");
        sb.append("    taxTypeIGST: ").append(this.toIndentedString(this.taxTypeIGST)).append("\n");
        sb.append("    totalExpense: ").append(this.toIndentedString(this.totalExpense)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

