/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.finances;

import com.amazon.spapi.model.finances.Currency;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="An item in an adjustment to the seller's account.")
public class AdjustmentItem {
    @SerializedName(value="Quantity")
    private String quantity = null;
    @SerializedName(value="PerUnitAmount")
    private Currency perUnitAmount = null;
    @SerializedName(value="TotalAmount")
    private Currency totalAmount = null;
    @SerializedName(value="SellerSKU")
    private String sellerSKU = null;
    @SerializedName(value="FnSKU")
    private String fnSKU = null;
    @SerializedName(value="ProductDescription")
    private String productDescription = null;
    @SerializedName(value="ASIN")
    private String ASIN = null;

    public AdjustmentItem quantity(String quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(value="Represents the number of units in the seller's inventory when the AdustmentType is FBAInventoryReimbursement.")
    public String getQuantity() {
        return this.quantity;
    }

    public void setQuantity(String quantity) {
        this.quantity = quantity;
    }

    public AdjustmentItem perUnitAmount(Currency perUnitAmount) {
        this.perUnitAmount = perUnitAmount;
        return this;
    }

    @ApiModelProperty(value="The per unit value of the item.")
    public Currency getPerUnitAmount() {
        return this.perUnitAmount;
    }

    public void setPerUnitAmount(Currency perUnitAmount) {
        this.perUnitAmount = perUnitAmount;
    }

    public AdjustmentItem totalAmount(Currency totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    @ApiModelProperty(value="The total value of the item.")
    public Currency getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(Currency totalAmount) {
        this.totalAmount = totalAmount;
    }

    public AdjustmentItem sellerSKU(String sellerSKU) {
        this.sellerSKU = sellerSKU;
        return this;
    }

    @ApiModelProperty(value="The seller SKU of the item. The seller SKU is qualified by the seller's seller ID, which is included with every call to the Selling Partner API.")
    public String getSellerSKU() {
        return this.sellerSKU;
    }

    public void setSellerSKU(String sellerSKU) {
        this.sellerSKU = sellerSKU;
    }

    public AdjustmentItem fnSKU(String fnSKU) {
        this.fnSKU = fnSKU;
        return this;
    }

    @ApiModelProperty(value="A unique identifier assigned to products stored in and fulfilled from a fulfillment center.")
    public String getFnSKU() {
        return this.fnSKU;
    }

    public void setFnSKU(String fnSKU) {
        this.fnSKU = fnSKU;
    }

    public AdjustmentItem productDescription(String productDescription) {
        this.productDescription = productDescription;
        return this;
    }

    @ApiModelProperty(value="A short description of the item.")
    public String getProductDescription() {
        return this.productDescription;
    }

    public void setProductDescription(String productDescription) {
        this.productDescription = productDescription;
    }

    public AdjustmentItem ASIN(String ASIN) {
        this.ASIN = ASIN;
        return this;
    }

    @ApiModelProperty(value="The Amazon Standard Identification Number (ASIN) of the item.")
    public String getASIN() {
        return this.ASIN;
    }

    public void setASIN(String ASIN) {
        this.ASIN = ASIN;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdjustmentItem adjustmentItem = (AdjustmentItem)o;
        return Objects.equals(this.quantity, adjustmentItem.quantity) && Objects.equals(this.perUnitAmount, adjustmentItem.perUnitAmount) && Objects.equals(this.totalAmount, adjustmentItem.totalAmount) && Objects.equals(this.sellerSKU, adjustmentItem.sellerSKU) && Objects.equals(this.fnSKU, adjustmentItem.fnSKU) && Objects.equals(this.productDescription, adjustmentItem.productDescription) && Objects.equals(this.ASIN, adjustmentItem.ASIN);
    }

    public int hashCode() {
        return Objects.hash(this.quantity, this.perUnitAmount, this.totalAmount, this.sellerSKU, this.fnSKU, this.productDescription, this.ASIN);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdjustmentItem {\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    perUnitAmount: ").append(this.toIndentedString(this.perUnitAmount)).append("\n");
        sb.append("    totalAmount: ").append(this.toIndentedString(this.totalAmount)).append("\n");
        sb.append("    sellerSKU: ").append(this.toIndentedString(this.sellerSKU)).append("\n");
        sb.append("    fnSKU: ").append(this.toIndentedString(this.fnSKU)).append("\n");
        sb.append("    productDescription: ").append(this.toIndentedString(this.productDescription)).append("\n");
        sb.append("    ASIN: ").append(this.toIndentedString(this.ASIN)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

