/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.finances;

import com.amazon.spapi.model.finances.AdjustmentItemList;
import com.amazon.spapi.model.finances.Currency;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="An adjustment to the seller's account.")
public class AdjustmentEvent {
    @SerializedName(value="AdjustmentType")
    private String adjustmentType = null;
    @SerializedName(value="PostedDate")
    private String postedDate = null;
    @SerializedName(value="AdjustmentAmount")
    private Currency adjustmentAmount = null;
    @SerializedName(value="AdjustmentItemList")
    private AdjustmentItemList adjustmentItemList = null;

    public AdjustmentEvent adjustmentType(String adjustmentType) {
        this.adjustmentType = adjustmentType;
        return this;
    }

    @ApiModelProperty(value="The type of adjustment.  Possible values:  * FBAInventoryReimbursement - An FBA inventory reimbursement to a seller's account. This occurs if a seller's inventory is damaged.  * ReserveEvent - A reserve event that is generated at the time of a settlement period closing. This occurs when some money from a seller's account is held back.  * PostageBilling - The amount paid by a seller for shipping labels.  * PostageRefund - The reimbursement of shipping labels purchased for orders that were canceled or refunded.  * LostOrDamagedReimbursement - An Amazon Easy Ship reimbursement to a seller's account for a package that we lost or damaged.  * CanceledButPickedUpReimbursement - An Amazon Easy Ship reimbursement to a seller's account. This occurs when a package is picked up and the order is subsequently canceled. This value is used only in the India marketplace.  * ReimbursementClawback - An Amazon Easy Ship reimbursement clawback from a seller's account. This occurs when a prior reimbursement is reversed. This value is used only in the India marketplace.  * SellerRewards - An award credited to a seller's account for their participation in an offer in the Seller Rewards program. Applies only to the India marketplace.")
    public String getAdjustmentType() {
        return this.adjustmentType;
    }

    public void setAdjustmentType(String adjustmentType) {
        this.adjustmentType = adjustmentType;
    }

    public AdjustmentEvent postedDate(String postedDate) {
        this.postedDate = postedDate;
        return this;
    }

    @ApiModelProperty(value="The date and time when the financial event was posted.")
    public String getPostedDate() {
        return this.postedDate;
    }

    public void setPostedDate(String postedDate) {
        this.postedDate = postedDate;
    }

    public AdjustmentEvent adjustmentAmount(Currency adjustmentAmount) {
        this.adjustmentAmount = adjustmentAmount;
        return this;
    }

    @ApiModelProperty(value="The amount adjusted as part of this event.")
    public Currency getAdjustmentAmount() {
        return this.adjustmentAmount;
    }

    public void setAdjustmentAmount(Currency adjustmentAmount) {
        this.adjustmentAmount = adjustmentAmount;
    }

    public AdjustmentEvent adjustmentItemList(AdjustmentItemList adjustmentItemList) {
        this.adjustmentItemList = adjustmentItemList;
        return this;
    }

    @ApiModelProperty(value="A list of information about adjustments to an account.")
    public AdjustmentItemList getAdjustmentItemList() {
        return this.adjustmentItemList;
    }

    public void setAdjustmentItemList(AdjustmentItemList adjustmentItemList) {
        this.adjustmentItemList = adjustmentItemList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdjustmentEvent adjustmentEvent = (AdjustmentEvent)o;
        return Objects.equals(this.adjustmentType, adjustmentEvent.adjustmentType) && Objects.equals(this.postedDate, adjustmentEvent.postedDate) && Objects.equals(this.adjustmentAmount, adjustmentEvent.adjustmentAmount) && Objects.equals(this.adjustmentItemList, adjustmentEvent.adjustmentItemList);
    }

    public int hashCode() {
        return Objects.hash(this.adjustmentType, this.postedDate, this.adjustmentAmount, this.adjustmentItemList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdjustmentEvent {\n");
        sb.append("    adjustmentType: ").append(this.toIndentedString(this.adjustmentType)).append("\n");
        sb.append("    postedDate: ").append(this.toIndentedString(this.postedDate)).append("\n");
        sb.append("    adjustmentAmount: ").append(this.toIndentedString(this.adjustmentAmount)).append("\n");
        sb.append("    adjustmentItemList: ").append(this.toIndentedString(this.adjustmentItemList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

