/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.feeds;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Detailed information about the feed.")
public class Feed {
    @SerializedName(value="feedId")
    private String feedId = null;
    @SerializedName(value="feedType")
    private String feedType = null;
    @SerializedName(value="marketplaceIds")
    private List<String> marketplaceIds = null;
    @SerializedName(value="createdTime")
    private OffsetDateTime createdTime = null;
    @SerializedName(value="processingStatus")
    private ProcessingStatusEnum processingStatus = null;
    @SerializedName(value="processingStartTime")
    private OffsetDateTime processingStartTime = null;
    @SerializedName(value="processingEndTime")
    private OffsetDateTime processingEndTime = null;
    @SerializedName(value="resultFeedDocumentId")
    private String resultFeedDocumentId = null;

    public Feed feedId(String feedId) {
        this.feedId = feedId;
        return this;
    }

    @ApiModelProperty(required=true, value="The identifier for the feed. This identifier is unique only in combination with a seller ID.")
    public String getFeedId() {
        return this.feedId;
    }

    public void setFeedId(String feedId) {
        this.feedId = feedId;
    }

    public Feed feedType(String feedType) {
        this.feedType = feedType;
        return this;
    }

    @ApiModelProperty(required=true, value="The feed type.")
    public String getFeedType() {
        return this.feedType;
    }

    public void setFeedType(String feedType) {
        this.feedType = feedType;
    }

    public Feed marketplaceIds(List<String> marketplaceIds) {
        this.marketplaceIds = marketplaceIds;
        return this;
    }

    public Feed addMarketplaceIdsItem(String marketplaceIdsItem) {
        if (this.marketplaceIds == null) {
            this.marketplaceIds = new ArrayList<String>();
        }
        this.marketplaceIds.add(marketplaceIdsItem);
        return this;
    }

    @ApiModelProperty(value="A list of identifiers for the marketplaces that the feed is applied to.")
    public List<String> getMarketplaceIds() {
        return this.marketplaceIds;
    }

    public void setMarketplaceIds(List<String> marketplaceIds) {
        this.marketplaceIds = marketplaceIds;
    }

    public Feed createdTime(OffsetDateTime createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    @ApiModelProperty(required=true, value="The date and time when the feed was created, in ISO 8601 date time format.")
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(OffsetDateTime createdTime) {
        this.createdTime = createdTime;
    }

    public Feed processingStatus(ProcessingStatusEnum processingStatus) {
        this.processingStatus = processingStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="The processing status of the feed.")
    public ProcessingStatusEnum getProcessingStatus() {
        return this.processingStatus;
    }

    public void setProcessingStatus(ProcessingStatusEnum processingStatus) {
        this.processingStatus = processingStatus;
    }

    public Feed processingStartTime(OffsetDateTime processingStartTime) {
        this.processingStartTime = processingStartTime;
        return this;
    }

    @ApiModelProperty(value="The date and time when feed processing started, in ISO 8601 date time format.")
    public OffsetDateTime getProcessingStartTime() {
        return this.processingStartTime;
    }

    public void setProcessingStartTime(OffsetDateTime processingStartTime) {
        this.processingStartTime = processingStartTime;
    }

    public Feed processingEndTime(OffsetDateTime processingEndTime) {
        this.processingEndTime = processingEndTime;
        return this;
    }

    @ApiModelProperty(value="The date and time when feed processing completed, in ISO 8601 date time format.")
    public OffsetDateTime getProcessingEndTime() {
        return this.processingEndTime;
    }

    public void setProcessingEndTime(OffsetDateTime processingEndTime) {
        this.processingEndTime = processingEndTime;
    }

    public Feed resultFeedDocumentId(String resultFeedDocumentId) {
        this.resultFeedDocumentId = resultFeedDocumentId;
        return this;
    }

    @ApiModelProperty(value="The identifier for the feed document. This identifier is unique only in combination with a seller ID.")
    public String getResultFeedDocumentId() {
        return this.resultFeedDocumentId;
    }

    public void setResultFeedDocumentId(String resultFeedDocumentId) {
        this.resultFeedDocumentId = resultFeedDocumentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Feed feed = (Feed)o;
        return Objects.equals(this.feedId, feed.feedId) && Objects.equals(this.feedType, feed.feedType) && Objects.equals(this.marketplaceIds, feed.marketplaceIds) && Objects.equals(this.createdTime, feed.createdTime) && Objects.equals((Object)this.processingStatus, (Object)feed.processingStatus) && Objects.equals(this.processingStartTime, feed.processingStartTime) && Objects.equals(this.processingEndTime, feed.processingEndTime) && Objects.equals(this.resultFeedDocumentId, feed.resultFeedDocumentId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.feedId, this.feedType, this.marketplaceIds, this.createdTime, this.processingStatus, this.processingStartTime, this.processingEndTime, this.resultFeedDocumentId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Feed {\n");
        sb.append("    feedId: ").append(this.toIndentedString(this.feedId)).append("\n");
        sb.append("    feedType: ").append(this.toIndentedString(this.feedType)).append("\n");
        sb.append("    marketplaceIds: ").append(this.toIndentedString(this.marketplaceIds)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    processingStatus: ").append(this.toIndentedString((Object)this.processingStatus)).append("\n");
        sb.append("    processingStartTime: ").append(this.toIndentedString(this.processingStartTime)).append("\n");
        sb.append("    processingEndTime: ").append(this.toIndentedString(this.processingEndTime)).append("\n");
        sb.append("    resultFeedDocumentId: ").append(this.toIndentedString(this.resultFeedDocumentId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ProcessingStatusEnum {
        CANCELLED("CANCELLED"),
        DONE("DONE"),
        FATAL("FATAL"),
        IN_PROGRESS("IN_PROGRESS"),
        IN_QUEUE("IN_QUEUE");

        private String value;

        private ProcessingStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ProcessingStatusEnum fromValue(String text) {
            for (ProcessingStatusEnum b : ProcessingStatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ProcessingStatusEnum> {
            public void write(JsonWriter jsonWriter, ProcessingStatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ProcessingStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ProcessingStatusEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

