/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.fbasmallandlight;

import com.amazon.spapi.model.fbasmallandlight.MoneyType;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="Fee details for a specific fee.")
public class FeeLineItem {
    @SerializedName(value="feeType")
    private FeeTypeEnum feeType = null;
    @SerializedName(value="feeCharge")
    private MoneyType feeCharge = null;

    public FeeLineItem feeType(FeeTypeEnum feeType) {
        this.feeType = feeType;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of fee charged to the seller.")
    public FeeTypeEnum getFeeType() {
        return this.feeType;
    }

    public void setFeeType(FeeTypeEnum feeType) {
        this.feeType = feeType;
    }

    public FeeLineItem feeCharge(MoneyType feeCharge) {
        this.feeCharge = feeCharge;
        return this;
    }

    @ApiModelProperty(required=true, value="Amount charged to the seller for the specific fee type.")
    public MoneyType getFeeCharge() {
        return this.feeCharge;
    }

    public void setFeeCharge(MoneyType feeCharge) {
        this.feeCharge = feeCharge;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeeLineItem feeLineItem = (FeeLineItem)o;
        return Objects.equals((Object)this.feeType, (Object)feeLineItem.feeType) && Objects.equals(this.feeCharge, feeLineItem.feeCharge);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.feeType, this.feeCharge});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeeLineItem {\n");
        sb.append("    feeType: ").append(this.toIndentedString((Object)this.feeType)).append("\n");
        sb.append("    feeCharge: ").append(this.toIndentedString(this.feeCharge)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FeeTypeEnum {
        FBAWEIGHTBASEDFEE("FBAWeightBasedFee"),
        FBAPERORDERFULFILLMENTFEE("FBAPerOrderFulfillmentFee"),
        FBAPERUNITFULFILLMENTFEE("FBAPerUnitFulfillmentFee"),
        COMMISSION("Commission");

        private String value;

        private FeeTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FeeTypeEnum fromValue(String text) {
            for (FeeTypeEnum b : FeeTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<FeeTypeEnum> {
            public void write(JsonWriter jsonWriter, FeeTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FeeTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FeeTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

