/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.catalogitems;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Sales rank of an Amazon catalog item by website display group.")
public class ItemDisplayGroupSalesRank {
    @SerializedName(value="websiteDisplayGroup")
    private String websiteDisplayGroup = null;
    @SerializedName(value="title")
    private String title = null;
    @SerializedName(value="link")
    private String link = null;
    @SerializedName(value="rank")
    private Integer rank = null;

    public ItemDisplayGroupSalesRank websiteDisplayGroup(String websiteDisplayGroup) {
        this.websiteDisplayGroup = websiteDisplayGroup;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the website display group associated with the sales rank")
    public String getWebsiteDisplayGroup() {
        return this.websiteDisplayGroup;
    }

    public void setWebsiteDisplayGroup(String websiteDisplayGroup) {
        this.websiteDisplayGroup = websiteDisplayGroup;
    }

    public ItemDisplayGroupSalesRank title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(required=true, value="Title, or name, of the sales rank.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ItemDisplayGroupSalesRank link(String link) {
        this.link = link;
        return this;
    }

    @ApiModelProperty(value="Corresponding Amazon retail website link, or URL, for the sales rank.")
    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public ItemDisplayGroupSalesRank rank(Integer rank) {
        this.rank = rank;
        return this;
    }

    @ApiModelProperty(required=true, value="Sales rank value.")
    public Integer getRank() {
        return this.rank;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemDisplayGroupSalesRank itemDisplayGroupSalesRank = (ItemDisplayGroupSalesRank)o;
        return Objects.equals(this.websiteDisplayGroup, itemDisplayGroupSalesRank.websiteDisplayGroup) && Objects.equals(this.title, itemDisplayGroupSalesRank.title) && Objects.equals(this.link, itemDisplayGroupSalesRank.link) && Objects.equals(this.rank, itemDisplayGroupSalesRank.rank);
    }

    public int hashCode() {
        return Objects.hash(this.websiteDisplayGroup, this.title, this.link, this.rank);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemDisplayGroupSalesRank {\n");
        sb.append("    websiteDisplayGroup: ").append(this.toIndentedString(this.websiteDisplayGroup)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    link: ").append(this.toIndentedString(this.link)).append("\n");
        sb.append("    rank: ").append(this.toIndentedString(this.rank)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

