/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.catalogitems;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Sales rank of an Amazon catalog item by classification.")
public class ItemClassificationSalesRank {
    @SerializedName(value="classificationId")
    private String classificationId = null;
    @SerializedName(value="title")
    private String title = null;
    @SerializedName(value="link")
    private String link = null;
    @SerializedName(value="rank")
    private Integer rank = null;

    public ItemClassificationSalesRank classificationId(String classificationId) {
        this.classificationId = classificationId;
        return this;
    }

    @ApiModelProperty(required=true, value="Identifier of the classification associated with the sales rank.")
    public String getClassificationId() {
        return this.classificationId;
    }

    public void setClassificationId(String classificationId) {
        this.classificationId = classificationId;
    }

    public ItemClassificationSalesRank title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(required=true, value="Title, or name, of the sales rank.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ItemClassificationSalesRank link(String link) {
        this.link = link;
        return this;
    }

    @ApiModelProperty(value="Corresponding Amazon retail website link, or URL, for the sales rank.")
    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public ItemClassificationSalesRank rank(Integer rank) {
        this.rank = rank;
        return this;
    }

    @ApiModelProperty(required=true, value="Sales rank value.")
    public Integer getRank() {
        return this.rank;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemClassificationSalesRank itemClassificationSalesRank = (ItemClassificationSalesRank)o;
        return Objects.equals(this.classificationId, itemClassificationSalesRank.classificationId) && Objects.equals(this.title, itemClassificationSalesRank.title) && Objects.equals(this.link, itemClassificationSalesRank.link) && Objects.equals(this.rank, itemClassificationSalesRank.rank);
    }

    public int hashCode() {
        return Objects.hash(this.classificationId, this.title, this.link, this.rank);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemClassificationSalesRank {\n");
        sb.append("    classificationId: ").append(this.toIndentedString(this.classificationId)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    link: ").append(this.toIndentedString(this.link)).append("\n");
        sb.append("    rank: ").append(this.toIndentedString(this.rank)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

