/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.apluscontent;

import com.amazon.spapi.model.apluscontent.ImageDimensions;
import com.amazon.spapi.model.apluscontent.ImageOffsets;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The instructions for optionally cropping an image. If no cropping is desired, set the dimensions to the original image size. If the image is cropped and no offset values are provided, then the coordinates of the top left corner of the cropped image, relative to the original image, are defaulted to (0,0).")
public class ImageCropSpecification {
    @SerializedName(value="size")
    private ImageDimensions size = null;
    @SerializedName(value="offset")
    private ImageOffsets offset = null;

    public ImageCropSpecification size(ImageDimensions size) {
        this.size = size;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ImageDimensions getSize() {
        return this.size;
    }

    public void setSize(ImageDimensions size) {
        this.size = size;
    }

    public ImageCropSpecification offset(ImageOffsets offset) {
        this.offset = offset;
        return this;
    }

    @ApiModelProperty(value="")
    public ImageOffsets getOffset() {
        return this.offset;
    }

    public void setOffset(ImageOffsets offset) {
        this.offset = offset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageCropSpecification imageCropSpecification = (ImageCropSpecification)o;
        return Objects.equals(this.size, imageCropSpecification.size) && Objects.equals(this.offset, imageCropSpecification.offset);
    }

    public int hashCode() {
        return Objects.hash(this.size, this.offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImageCropSpecification {\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    offset: ").append(this.toIndentedString(this.offset)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

