/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.model.apluscontent;

import com.amazon.spapi.model.apluscontent.DecoratorType;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A decorator applied to a content string value in order to create rich text.")
public class Decorator {
    @SerializedName(value="type")
    private DecoratorType type = null;
    @SerializedName(value="offset")
    private Integer offset = null;
    @SerializedName(value="length")
    private Integer length = null;
    @SerializedName(value="depth")
    private Integer depth = null;

    public Decorator type(DecoratorType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="")
    public DecoratorType getType() {
        return this.type;
    }

    public void setType(DecoratorType type) {
        this.type = type;
    }

    public Decorator offset(Integer offset) {
        this.offset = offset;
        return this;
    }

    @ApiModelProperty(value="The starting character of this decorator within the content string. Use zero for the first character.")
    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Decorator length(Integer length) {
        this.length = length;
        return this;
    }

    @ApiModelProperty(value="The number of content characters to alter with this decorator. Decorators such as line breaks can have zero length and fit between characters.")
    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public Decorator depth(Integer depth) {
        this.depth = depth;
        return this;
    }

    @ApiModelProperty(value="The relative intensity or variation of this decorator. Decorators such as bullet-points, for example, can have multiple indentation depths.")
    public Integer getDepth() {
        return this.depth;
    }

    public void setDepth(Integer depth) {
        this.depth = depth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Decorator decorator = (Decorator)o;
        return Objects.equals((Object)this.type, (Object)decorator.type) && Objects.equals(this.offset, decorator.offset) && Objects.equals(this.length, decorator.length) && Objects.equals(this.depth, decorator.depth);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.offset, this.length, this.depth});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Decorator {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    offset: ").append(this.toIndentedString(this.offset)).append("\n");
        sb.append("    length: ").append(this.toIndentedString(this.length)).append("\n");
        sb.append("    depth: ").append(this.toIndentedString(this.depth)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

