/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.documents.impl;

import com.amazon.spapi.documents.HttpTransferClient;
import com.amazon.spapi.documents.exception.HttpResponseException;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class OkHttpTransferClient
implements HttpTransferClient {
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private final OkHttpClient client;
    private final int maxErrorBodyLen;

    private OkHttpTransferClient(OkHttpClient client, int maxErrorBodyLen) {
        this.client = client;
        this.maxErrorBodyLen = maxErrorBodyLen;
    }

    private HttpResponseException createResponseException(Response response) {
        String body = "";
        if (this.maxErrorBodyLen > 0) {
            try (Reader bodyReader = response.body().charStream();){
                char[] buf = new char[this.maxErrorBodyLen];
                int charsRead = IOUtils.read((Reader)bodyReader, (char[])buf);
                if (charsRead > 0) {
                    body = new String(buf, 0, charsRead);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new HttpResponseException(response.message(), body, response.code());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String download(String url, File destination) throws HttpResponseException, IOException {
        Request request = new Request.Builder().url(url).get().build();
        Response response = this.client.newCall(request).execute();
        try {
            if (!response.isSuccessful()) {
                throw this.createResponseException(response);
            }
            FileUtils.copyInputStreamToFile((InputStream)response.body().byteStream(), (File)destination);
        }
        finally {
            IOUtils.closeQuietly((Closeable)response.body());
        }
        return response.header(CONTENT_TYPE_HEADER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upload(String url, String contentType, File source) throws HttpResponseException, IOException {
        Request request = new Request.Builder().url(url).put(RequestBody.create((MediaType)MediaType.parse((String)contentType), (File)source)).build();
        Response response = this.client.newCall(request).execute();
        try {
            if (!response.isSuccessful()) {
                throw this.createResponseException(response);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)response.body());
        }
    }

    public static class Builder {
        private OkHttpClient client = null;
        private int maxErrorBodyLen = 4096;

        public Builder withClient(OkHttpClient client) {
            this.client = client;
            return this;
        }

        public Builder withMaxErrorBodyLen(int maxErrorBodyLen) {
            this.maxErrorBodyLen = maxErrorBodyLen;
            return this;
        }

        public OkHttpTransferClient build() {
            if (this.client == null) {
                this.client = new OkHttpClient();
            }
            return new OkHttpTransferClient(this.client, this.maxErrorBodyLen);
        }
    }
}

