/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.documents.impl;

import com.amazon.spapi.documents.CryptoStreamFactory;
import com.amazon.spapi.documents.exception.CryptoException;
import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESCryptoStreamFactory
implements CryptoStreamFactory {
    private static final String ENCRYPTION_ALGORITHM = "AES/CBC/PKCS5Padding";
    private final Key key;
    private final byte[] initializationVector;

    private AESCryptoStreamFactory(Key key, byte[] initializationVector) {
        this.key = key;
        this.initializationVector = initializationVector;
    }

    private Cipher createInitializedCipher(int mode) throws CryptoException {
        try {
            Cipher cipher = Cipher.getInstance(ENCRYPTION_ALGORITHM);
            cipher.init(mode, this.key, new IvParameterSpec(this.initializationVector));
            return cipher;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new CryptoException(e);
        }
    }

    @Override
    public InputStream newDecryptStream(InputStream source) throws CryptoException {
        return new CipherInputStream(source, this.createInitializedCipher(2));
    }

    @Override
    public InputStream newEncryptStream(InputStream source) throws CryptoException {
        return new CipherInputStream(source, this.createInitializedCipher(1));
    }

    public static class Builder {
        private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
        private static final String REQUIRED_KEY_ALGORITHM = "AES";
        private final String key;
        private final String initializationVector;

        public Builder(String key, String initializationVector) {
            Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key is required");
            Preconditions.checkArgument((initializationVector != null ? 1 : 0) != 0, (Object)"initializationVector is required");
            this.key = key;
            this.initializationVector = initializationVector;
        }

        public AESCryptoStreamFactory build() {
            SecretKeySpec convertedKey = new SecretKeySpec(BASE64_DECODER.decode(this.key), REQUIRED_KEY_ALGORITHM);
            byte[] convertedInitializationVector = BASE64_DECODER.decode(this.initializationVector);
            return new AESCryptoStreamFactory(convertedKey, convertedInitializationVector);
        }
    }
}

