/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.documents;

import com.amazon.spapi.documents.CryptoStreamFactory;
import com.google.common.base.Preconditions;
import java.io.InputStream;

public class UploadSpecification {
    private final String contentType;
    private final CryptoStreamFactory cryptoStreamFactory;
    private final InputStream source;
    private final String url;

    private UploadSpecification(String contentType, CryptoStreamFactory cryptoStreamFactory, InputStream source, String url) {
        this.contentType = contentType;
        this.cryptoStreamFactory = cryptoStreamFactory;
        this.source = source;
        this.url = url;
    }

    String getContentType() {
        return this.contentType;
    }

    CryptoStreamFactory getCryptoStreamFactory() {
        return this.cryptoStreamFactory;
    }

    InputStream getSource() {
        return this.source;
    }

    String getUrl() {
        return this.url;
    }

    public static class Builder {
        private final String contentType;
        private final CryptoStreamFactory cryptoStreamFactory;
        private final InputStream source;
        private final String url;

        public Builder(String contentType, CryptoStreamFactory cryptoStreamFactory, InputStream source, String url) {
            Preconditions.checkArgument((contentType != null ? 1 : 0) != 0, (Object)"contentType is required");
            Preconditions.checkArgument((cryptoStreamFactory != null ? 1 : 0) != 0, (Object)"cryptoStreamFactory is required");
            Preconditions.checkArgument((source != null ? 1 : 0) != 0, (Object)"source is required");
            Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"url is required");
            this.contentType = contentType;
            this.cryptoStreamFactory = cryptoStreamFactory;
            this.source = source;
            this.url = url;
        }

        public UploadSpecification build() {
            return new UploadSpecification(this.contentType, this.cryptoStreamFactory, this.source, this.url);
        }
    }
}

