/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.documents;

import com.amazon.spapi.documents.HttpTransferClient;
import com.amazon.spapi.documents.UploadSpecification;
import com.amazon.spapi.documents.exception.CryptoException;
import com.amazon.spapi.documents.exception.HttpResponseException;
import com.amazon.spapi.documents.impl.OkHttpTransferClient;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;

public class UploadHelper {
    private final HttpTransferClient httpTransferClient;
    private final String tmpFilePrefix;
    private final String tmpFileSuffix;
    private final File tmpFileDirectory;

    private UploadHelper(HttpTransferClient httpTransferClient, String tmpFilePrefix, String tmpFileSuffix, File tmpFileDirectory) {
        this.httpTransferClient = httpTransferClient;
        this.tmpFilePrefix = tmpFilePrefix;
        this.tmpFileSuffix = tmpFileSuffix;
        this.tmpFileDirectory = tmpFileDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(UploadSpecification spec) throws CryptoException, HttpResponseException, IOException {
        File tmpFile = File.createTempFile(this.tmpFilePrefix, this.tmpFileSuffix, this.tmpFileDirectory);
        try {
            tmpFile.deleteOnExit();
            try (InputStream inputStream = spec.getCryptoStreamFactory().newEncryptStream(spec.getSource());){
                FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tmpFile);
            }
            this.httpTransferClient.upload(spec.getUrl(), spec.getContentType(), tmpFile);
        }
        finally {
            tmpFile.delete();
        }
    }

    public static class Builder {
        private HttpTransferClient httpTransferClient = null;
        private String tmpFilePrefix = "SPAPI";
        private String tmpFileSuffix = null;
        private File tmpFileDirectory = null;

        public Builder withHttpTransferClient(HttpTransferClient httpTransferClient) {
            this.httpTransferClient = httpTransferClient;
            return this;
        }

        public Builder withTmpFilePrefix(String tmpFilePrefix) {
            if (tmpFilePrefix.length() < 3) {
                throw new IllegalArgumentException("Prefix string too short");
            }
            this.tmpFilePrefix = tmpFilePrefix;
            return this;
        }

        public Builder withTmpFileSuffix(String tmpFileSuffix) {
            this.tmpFileSuffix = tmpFileSuffix;
            return this;
        }

        public Builder withTmpFileDirectory(File tmpFileDirectory) {
            this.tmpFileDirectory = tmpFileDirectory;
            return this;
        }

        public UploadHelper build() {
            if (this.httpTransferClient == null) {
                this.httpTransferClient = new OkHttpTransferClient.Builder().build();
            }
            return new UploadHelper(this.httpTransferClient, this.tmpFilePrefix, this.tmpFileSuffix, this.tmpFileDirectory);
        }
    }
}

