/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.documents;

import com.amazon.spapi.documents.CompressionAlgorithm;
import com.amazon.spapi.documents.CryptoStreamFactory;
import com.google.common.base.Preconditions;

public class DownloadSpecification {
    private final CompressionAlgorithm compressionAlgorithm;
    private final CryptoStreamFactory cryptoStreamFactory;
    private final String url;

    private DownloadSpecification(CompressionAlgorithm compressionAlgorithm, CryptoStreamFactory cryptoStreamFactory, String url) {
        this.compressionAlgorithm = compressionAlgorithm;
        this.cryptoStreamFactory = cryptoStreamFactory;
        this.url = url;
    }

    CompressionAlgorithm getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    CryptoStreamFactory getCryptoStreamFactory() {
        return this.cryptoStreamFactory;
    }

    String getUrl() {
        return this.url;
    }

    public static class Builder {
        private final CryptoStreamFactory cryptoStreamFactory;
        private final String url;
        private CompressionAlgorithm compressionAlgorithm = null;

        public Builder(CryptoStreamFactory cryptoStreamFactory, String url) {
            Preconditions.checkArgument((cryptoStreamFactory != null ? 1 : 0) != 0, (Object)"cryptoStreamFactory is required");
            Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"url is required");
            this.cryptoStreamFactory = cryptoStreamFactory;
            this.url = url;
        }

        public Builder withCompressionAlgorithm(CompressionAlgorithm compressionAlgorithm) {
            this.compressionAlgorithm = compressionAlgorithm;
            return this;
        }

        public DownloadSpecification build() {
            return new DownloadSpecification(this.compressionAlgorithm, this.cryptoStreamFactory, this.url);
        }
    }
}

