/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.documents;

import com.amazon.spapi.documents.DownloadBundle;
import com.amazon.spapi.documents.DownloadSpecification;
import com.amazon.spapi.documents.HttpTransferClient;
import com.amazon.spapi.documents.exception.HttpResponseException;
import com.amazon.spapi.documents.impl.OkHttpTransferClient;
import java.io.File;
import java.io.IOException;

public class DownloadHelper {
    private final HttpTransferClient httpTransferClient;
    private final String tmpFilePrefix;
    private final String tmpFileSuffix;
    private final File tmpFileDirectory;

    private DownloadHelper(HttpTransferClient httpTransferClient, String tmpFilePrefix, String tmpFileSuffix, File tmpFileDirectory) {
        this.httpTransferClient = httpTransferClient;
        this.tmpFilePrefix = tmpFilePrefix;
        this.tmpFileSuffix = tmpFileSuffix;
        this.tmpFileDirectory = tmpFileDirectory;
    }

    public DownloadBundle download(DownloadSpecification spec) throws HttpResponseException, IOException {
        File tmpFile = File.createTempFile(this.tmpFilePrefix, this.tmpFileSuffix, this.tmpFileDirectory);
        try {
            tmpFile.deleteOnExit();
            String contentType = this.httpTransferClient.download(spec.getUrl(), tmpFile);
            return new DownloadBundle(spec.getCompressionAlgorithm(), contentType, spec.getCryptoStreamFactory(), tmpFile);
        }
        catch (Exception e) {
            tmpFile.delete();
            throw e;
        }
    }

    public static class Builder {
        private HttpTransferClient httpTransferClient = null;
        private String tmpFilePrefix = "SPAPI";
        private String tmpFileSuffix = null;
        private File tmpFileDirectory = null;

        public Builder withHttpTransferClient(HttpTransferClient httpTransferClient) {
            this.httpTransferClient = httpTransferClient;
            return this;
        }

        public Builder withTmpFilePrefix(String tmpFilePrefix) {
            if (tmpFilePrefix.length() < 3) {
                throw new IllegalArgumentException("Prefix string too short");
            }
            this.tmpFilePrefix = tmpFilePrefix;
            return this;
        }

        public Builder withTmpFileSuffix(String tmpFileSuffix) {
            this.tmpFileSuffix = tmpFileSuffix;
            return this;
        }

        public Builder withTmpFileDirectory(File tmpFileDirectory) {
            this.tmpFileDirectory = tmpFileDirectory;
            return this;
        }

        public DownloadHelper build() {
            if (this.httpTransferClient == null) {
                this.httpTransferClient = new OkHttpTransferClient.Builder().build();
            }
            return new DownloadHelper(this.httpTransferClient, this.tmpFilePrefix, this.tmpFileSuffix, this.tmpFileDirectory);
        }
    }
}

