/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.documents;

import com.amazon.spapi.documents.CompressionAlgorithm;
import com.amazon.spapi.documents.CryptoStreamFactory;
import com.amazon.spapi.documents.exception.CryptoException;
import com.amazon.spapi.documents.exception.MissingCharsetException;
import com.squareup.okhttp.MediaType;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;

public class DownloadBundle
implements AutoCloseable {
    private final CompressionAlgorithm compressionAlgorithm;
    private final String contentType;
    private final CryptoStreamFactory cryptoStreamFactory;
    private final File document;

    DownloadBundle(CompressionAlgorithm compressionAlgorithm, String contentType, CryptoStreamFactory cryptoStreamFactory, File document) {
        this.compressionAlgorithm = compressionAlgorithm;
        this.contentType = contentType;
        this.cryptoStreamFactory = cryptoStreamFactory;
        this.document = document;
    }

    public String getContentType() {
        return this.contentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream newInputStream() throws CryptoException, IOException {
        InputStream inputStream;
        FileInputStream closeThis = null;
        try {
            InputStream inputStream2;
            closeThis = inputStream2 = new FileInputStream(this.document);
            closeThis = inputStream2 = this.cryptoStreamFactory.newDecryptStream(inputStream2);
            if (this.compressionAlgorithm != null) {
                switch (this.compressionAlgorithm) {
                    case GZIP: {
                        closeThis = inputStream2 = new GZIPInputStream(inputStream2);
                    }
                }
            }
            closeThis = null;
            inputStream = inputStream2;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(closeThis);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)closeThis);
        return inputStream;
    }

    public BufferedReader newBufferedReader() throws CryptoException, IOException, MissingCharsetException {
        return this.newBufferedReader(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedReader newBufferedReader(Charset defaultCharset) throws CryptoException, IOException, MissingCharsetException {
        BufferedReader bufferedReader;
        String contentType = this.getContentType();
        Charset charset = MediaType.parse((String)contentType).charset();
        if (charset == null) {
            charset = defaultCharset;
        }
        if (charset == null) {
            throw new MissingCharsetException(String.format("Could not parse character set from content type '%s' and no default provided", contentType));
        }
        Closeable closeThis = null;
        try {
            InputStream inputStream;
            closeThis = inputStream = this.newInputStream();
            InputStreamReader reader = new InputStreamReader(inputStream, charset);
            closeThis = reader;
            BufferedReader bufferedReader2 = new BufferedReader(reader);
            closeThis = null;
            bufferedReader = bufferedReader2;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(closeThis);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)closeThis);
        return bufferedReader;
    }

    @Override
    public void close() {
        this.document.delete();
    }
}

