/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.spapi.api;

import com.amazon.spapi.SellingPartnerAPIAA.AWSAuthenticationCredentials;
import com.amazon.spapi.SellingPartnerAPIAA.AWSAuthenticationCredentialsProvider;
import com.amazon.spapi.SellingPartnerAPIAA.AWSSigV4Signer;
import com.amazon.spapi.SellingPartnerAPIAA.LWAAccessTokenCache;
import com.amazon.spapi.SellingPartnerAPIAA.LWAAccessTokenCacheImpl;
import com.amazon.spapi.SellingPartnerAPIAA.LWAAuthorizationCredentials;
import com.amazon.spapi.SellingPartnerAPIAA.LWAAuthorizationSigner;
import com.amazon.spapi.client.ApiCallback;
import com.amazon.spapi.client.ApiClient;
import com.amazon.spapi.client.ApiException;
import com.amazon.spapi.client.ApiResponse;
import com.amazon.spapi.client.Configuration;
import com.amazon.spapi.client.Pair;
import com.amazon.spapi.client.ProgressRequestBody;
import com.amazon.spapi.client.ProgressResponseBody;
import com.amazon.spapi.client.StringUtil;
import com.amazon.spapi.model.apluscontent.GetContentDocumentResponse;
import com.amazon.spapi.model.apluscontent.ListContentDocumentAsinRelationsResponse;
import com.amazon.spapi.model.apluscontent.PostContentDocumentApprovalSubmissionResponse;
import com.amazon.spapi.model.apluscontent.PostContentDocumentAsinRelationsRequest;
import com.amazon.spapi.model.apluscontent.PostContentDocumentAsinRelationsResponse;
import com.amazon.spapi.model.apluscontent.PostContentDocumentRequest;
import com.amazon.spapi.model.apluscontent.PostContentDocumentResponse;
import com.amazon.spapi.model.apluscontent.PostContentDocumentSuspendSubmissionResponse;
import com.amazon.spapi.model.apluscontent.SearchContentDocumentsResponse;
import com.amazon.spapi.model.apluscontent.SearchContentPublishRecordsResponse;
import com.amazon.spapi.model.apluscontent.ValidateContentDocumentAsinRelationsResponse;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AplusContentApi {
    private ApiClient apiClient;

    AplusContentApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AplusContentApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createContentDocumentCall(String marketplaceId, PostContentDocumentRequest postContentDocumentRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        PostContentDocumentRequest localVarPostBody = postContentDocumentRequest;
        String localVarPath = "/aplus/2020-11-01/contentDocuments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createContentDocumentValidateBeforeCall(String marketplaceId, PostContentDocumentRequest postContentDocumentRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling createContentDocument(Async)");
        }
        if (postContentDocumentRequest == null) {
            throw new ApiException("Missing the required parameter 'postContentDocumentRequest' when calling createContentDocument(Async)");
        }
        Call call = this.createContentDocumentCall(marketplaceId, postContentDocumentRequest, progressListener, progressRequestListener);
        return call;
    }

    public PostContentDocumentResponse createContentDocument(String marketplaceId, PostContentDocumentRequest postContentDocumentRequest) throws ApiException {
        ApiResponse<PostContentDocumentResponse> resp = this.createContentDocumentWithHttpInfo(marketplaceId, postContentDocumentRequest);
        return resp.getData();
    }

    public ApiResponse<PostContentDocumentResponse> createContentDocumentWithHttpInfo(String marketplaceId, PostContentDocumentRequest postContentDocumentRequest) throws ApiException {
        Call call = this.createContentDocumentValidateBeforeCall(marketplaceId, postContentDocumentRequest, null, null);
        Type localVarReturnType = new TypeToken<PostContentDocumentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createContentDocumentAsync(String marketplaceId, PostContentDocumentRequest postContentDocumentRequest, final ApiCallback<PostContentDocumentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createContentDocumentValidateBeforeCall(marketplaceId, postContentDocumentRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PostContentDocumentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getContentDocumentCall(String contentReferenceKey, String marketplaceId, List<String> includedDataSet, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/aplus/2020-11-01/contentDocuments/{contentReferenceKey}".replaceAll("\\{contentReferenceKey\\}", this.apiClient.escapeString(contentReferenceKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        if (includedDataSet != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "includedDataSet", includedDataSet));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getContentDocumentValidateBeforeCall(String contentReferenceKey, String marketplaceId, List<String> includedDataSet, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (contentReferenceKey == null) {
            throw new ApiException("Missing the required parameter 'contentReferenceKey' when calling getContentDocument(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling getContentDocument(Async)");
        }
        if (includedDataSet == null) {
            throw new ApiException("Missing the required parameter 'includedDataSet' when calling getContentDocument(Async)");
        }
        Call call = this.getContentDocumentCall(contentReferenceKey, marketplaceId, includedDataSet, progressListener, progressRequestListener);
        return call;
    }

    public GetContentDocumentResponse getContentDocument(String contentReferenceKey, String marketplaceId, List<String> includedDataSet) throws ApiException {
        ApiResponse<GetContentDocumentResponse> resp = this.getContentDocumentWithHttpInfo(contentReferenceKey, marketplaceId, includedDataSet);
        return resp.getData();
    }

    public ApiResponse<GetContentDocumentResponse> getContentDocumentWithHttpInfo(String contentReferenceKey, String marketplaceId, List<String> includedDataSet) throws ApiException {
        Call call = this.getContentDocumentValidateBeforeCall(contentReferenceKey, marketplaceId, includedDataSet, null, null);
        Type localVarReturnType = new TypeToken<GetContentDocumentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getContentDocumentAsync(String contentReferenceKey, String marketplaceId, List<String> includedDataSet, final ApiCallback<GetContentDocumentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getContentDocumentValidateBeforeCall(contentReferenceKey, marketplaceId, includedDataSet, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetContentDocumentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listContentDocumentAsinRelationsCall(String contentReferenceKey, String marketplaceId, List<String> includedDataSet, List<String> asinSet, String pageToken, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/aplus/2020-11-01/contentDocuments/{contentReferenceKey}/asins".replaceAll("\\{contentReferenceKey\\}", this.apiClient.escapeString(contentReferenceKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        if (includedDataSet != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "includedDataSet", includedDataSet));
        }
        if (asinSet != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "asinSet", asinSet));
        }
        if (pageToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pageToken", pageToken));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listContentDocumentAsinRelationsValidateBeforeCall(String contentReferenceKey, String marketplaceId, List<String> includedDataSet, List<String> asinSet, String pageToken, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (contentReferenceKey == null) {
            throw new ApiException("Missing the required parameter 'contentReferenceKey' when calling listContentDocumentAsinRelations(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling listContentDocumentAsinRelations(Async)");
        }
        Call call = this.listContentDocumentAsinRelationsCall(contentReferenceKey, marketplaceId, includedDataSet, asinSet, pageToken, progressListener, progressRequestListener);
        return call;
    }

    public ListContentDocumentAsinRelationsResponse listContentDocumentAsinRelations(String contentReferenceKey, String marketplaceId, List<String> includedDataSet, List<String> asinSet, String pageToken) throws ApiException {
        ApiResponse<ListContentDocumentAsinRelationsResponse> resp = this.listContentDocumentAsinRelationsWithHttpInfo(contentReferenceKey, marketplaceId, includedDataSet, asinSet, pageToken);
        return resp.getData();
    }

    public ApiResponse<ListContentDocumentAsinRelationsResponse> listContentDocumentAsinRelationsWithHttpInfo(String contentReferenceKey, String marketplaceId, List<String> includedDataSet, List<String> asinSet, String pageToken) throws ApiException {
        Call call = this.listContentDocumentAsinRelationsValidateBeforeCall(contentReferenceKey, marketplaceId, includedDataSet, asinSet, pageToken, null, null);
        Type localVarReturnType = new TypeToken<ListContentDocumentAsinRelationsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listContentDocumentAsinRelationsAsync(String contentReferenceKey, String marketplaceId, List<String> includedDataSet, List<String> asinSet, String pageToken, final ApiCallback<ListContentDocumentAsinRelationsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listContentDocumentAsinRelationsValidateBeforeCall(contentReferenceKey, marketplaceId, includedDataSet, asinSet, pageToken, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ListContentDocumentAsinRelationsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postContentDocumentApprovalSubmissionCall(String contentReferenceKey, String marketplaceId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/aplus/2020-11-01/contentDocuments/{contentReferenceKey}/approvalSubmissions".replaceAll("\\{contentReferenceKey\\}", this.apiClient.escapeString(contentReferenceKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postContentDocumentApprovalSubmissionValidateBeforeCall(String contentReferenceKey, String marketplaceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (contentReferenceKey == null) {
            throw new ApiException("Missing the required parameter 'contentReferenceKey' when calling postContentDocumentApprovalSubmission(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling postContentDocumentApprovalSubmission(Async)");
        }
        Call call = this.postContentDocumentApprovalSubmissionCall(contentReferenceKey, marketplaceId, progressListener, progressRequestListener);
        return call;
    }

    public PostContentDocumentApprovalSubmissionResponse postContentDocumentApprovalSubmission(String contentReferenceKey, String marketplaceId) throws ApiException {
        ApiResponse<PostContentDocumentApprovalSubmissionResponse> resp = this.postContentDocumentApprovalSubmissionWithHttpInfo(contentReferenceKey, marketplaceId);
        return resp.getData();
    }

    public ApiResponse<PostContentDocumentApprovalSubmissionResponse> postContentDocumentApprovalSubmissionWithHttpInfo(String contentReferenceKey, String marketplaceId) throws ApiException {
        Call call = this.postContentDocumentApprovalSubmissionValidateBeforeCall(contentReferenceKey, marketplaceId, null, null);
        Type localVarReturnType = new TypeToken<PostContentDocumentApprovalSubmissionResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postContentDocumentApprovalSubmissionAsync(String contentReferenceKey, String marketplaceId, final ApiCallback<PostContentDocumentApprovalSubmissionResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postContentDocumentApprovalSubmissionValidateBeforeCall(contentReferenceKey, marketplaceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PostContentDocumentApprovalSubmissionResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postContentDocumentAsinRelationsCall(String contentReferenceKey, String marketplaceId, PostContentDocumentAsinRelationsRequest postContentDocumentAsinRelationsRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        PostContentDocumentAsinRelationsRequest localVarPostBody = postContentDocumentAsinRelationsRequest;
        String localVarPath = "/aplus/2020-11-01/contentDocuments/{contentReferenceKey}/asins".replaceAll("\\{contentReferenceKey\\}", this.apiClient.escapeString(contentReferenceKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postContentDocumentAsinRelationsValidateBeforeCall(String contentReferenceKey, String marketplaceId, PostContentDocumentAsinRelationsRequest postContentDocumentAsinRelationsRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (contentReferenceKey == null) {
            throw new ApiException("Missing the required parameter 'contentReferenceKey' when calling postContentDocumentAsinRelations(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling postContentDocumentAsinRelations(Async)");
        }
        if (postContentDocumentAsinRelationsRequest == null) {
            throw new ApiException("Missing the required parameter 'postContentDocumentAsinRelationsRequest' when calling postContentDocumentAsinRelations(Async)");
        }
        Call call = this.postContentDocumentAsinRelationsCall(contentReferenceKey, marketplaceId, postContentDocumentAsinRelationsRequest, progressListener, progressRequestListener);
        return call;
    }

    public PostContentDocumentAsinRelationsResponse postContentDocumentAsinRelations(String contentReferenceKey, String marketplaceId, PostContentDocumentAsinRelationsRequest postContentDocumentAsinRelationsRequest) throws ApiException {
        ApiResponse<PostContentDocumentAsinRelationsResponse> resp = this.postContentDocumentAsinRelationsWithHttpInfo(contentReferenceKey, marketplaceId, postContentDocumentAsinRelationsRequest);
        return resp.getData();
    }

    public ApiResponse<PostContentDocumentAsinRelationsResponse> postContentDocumentAsinRelationsWithHttpInfo(String contentReferenceKey, String marketplaceId, PostContentDocumentAsinRelationsRequest postContentDocumentAsinRelationsRequest) throws ApiException {
        Call call = this.postContentDocumentAsinRelationsValidateBeforeCall(contentReferenceKey, marketplaceId, postContentDocumentAsinRelationsRequest, null, null);
        Type localVarReturnType = new TypeToken<PostContentDocumentAsinRelationsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postContentDocumentAsinRelationsAsync(String contentReferenceKey, String marketplaceId, PostContentDocumentAsinRelationsRequest postContentDocumentAsinRelationsRequest, final ApiCallback<PostContentDocumentAsinRelationsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postContentDocumentAsinRelationsValidateBeforeCall(contentReferenceKey, marketplaceId, postContentDocumentAsinRelationsRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PostContentDocumentAsinRelationsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postContentDocumentSuspendSubmissionCall(String contentReferenceKey, String marketplaceId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/aplus/2020-11-01/contentDocuments/{contentReferenceKey}/suspendSubmissions".replaceAll("\\{contentReferenceKey\\}", this.apiClient.escapeString(contentReferenceKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postContentDocumentSuspendSubmissionValidateBeforeCall(String contentReferenceKey, String marketplaceId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (contentReferenceKey == null) {
            throw new ApiException("Missing the required parameter 'contentReferenceKey' when calling postContentDocumentSuspendSubmission(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling postContentDocumentSuspendSubmission(Async)");
        }
        Call call = this.postContentDocumentSuspendSubmissionCall(contentReferenceKey, marketplaceId, progressListener, progressRequestListener);
        return call;
    }

    public PostContentDocumentSuspendSubmissionResponse postContentDocumentSuspendSubmission(String contentReferenceKey, String marketplaceId) throws ApiException {
        ApiResponse<PostContentDocumentSuspendSubmissionResponse> resp = this.postContentDocumentSuspendSubmissionWithHttpInfo(contentReferenceKey, marketplaceId);
        return resp.getData();
    }

    public ApiResponse<PostContentDocumentSuspendSubmissionResponse> postContentDocumentSuspendSubmissionWithHttpInfo(String contentReferenceKey, String marketplaceId) throws ApiException {
        Call call = this.postContentDocumentSuspendSubmissionValidateBeforeCall(contentReferenceKey, marketplaceId, null, null);
        Type localVarReturnType = new TypeToken<PostContentDocumentSuspendSubmissionResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postContentDocumentSuspendSubmissionAsync(String contentReferenceKey, String marketplaceId, final ApiCallback<PostContentDocumentSuspendSubmissionResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postContentDocumentSuspendSubmissionValidateBeforeCall(contentReferenceKey, marketplaceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PostContentDocumentSuspendSubmissionResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call searchContentDocumentsCall(String marketplaceId, String pageToken, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/aplus/2020-11-01/contentDocuments";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        if (pageToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pageToken", pageToken));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call searchContentDocumentsValidateBeforeCall(String marketplaceId, String pageToken, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling searchContentDocuments(Async)");
        }
        Call call = this.searchContentDocumentsCall(marketplaceId, pageToken, progressListener, progressRequestListener);
        return call;
    }

    public SearchContentDocumentsResponse searchContentDocuments(String marketplaceId, String pageToken) throws ApiException {
        ApiResponse<SearchContentDocumentsResponse> resp = this.searchContentDocumentsWithHttpInfo(marketplaceId, pageToken);
        return resp.getData();
    }

    public ApiResponse<SearchContentDocumentsResponse> searchContentDocumentsWithHttpInfo(String marketplaceId, String pageToken) throws ApiException {
        Call call = this.searchContentDocumentsValidateBeforeCall(marketplaceId, pageToken, null, null);
        Type localVarReturnType = new TypeToken<SearchContentDocumentsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call searchContentDocumentsAsync(String marketplaceId, String pageToken, final ApiCallback<SearchContentDocumentsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.searchContentDocumentsValidateBeforeCall(marketplaceId, pageToken, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SearchContentDocumentsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call searchContentPublishRecordsCall(String marketplaceId, String asin, String pageToken, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/aplus/2020-11-01/contentPublishRecords";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        if (asin != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("asin", asin));
        }
        if (pageToken != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pageToken", pageToken));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call searchContentPublishRecordsValidateBeforeCall(String marketplaceId, String asin, String pageToken, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling searchContentPublishRecords(Async)");
        }
        if (asin == null) {
            throw new ApiException("Missing the required parameter 'asin' when calling searchContentPublishRecords(Async)");
        }
        Call call = this.searchContentPublishRecordsCall(marketplaceId, asin, pageToken, progressListener, progressRequestListener);
        return call;
    }

    public SearchContentPublishRecordsResponse searchContentPublishRecords(String marketplaceId, String asin, String pageToken) throws ApiException {
        ApiResponse<SearchContentPublishRecordsResponse> resp = this.searchContentPublishRecordsWithHttpInfo(marketplaceId, asin, pageToken);
        return resp.getData();
    }

    public ApiResponse<SearchContentPublishRecordsResponse> searchContentPublishRecordsWithHttpInfo(String marketplaceId, String asin, String pageToken) throws ApiException {
        Call call = this.searchContentPublishRecordsValidateBeforeCall(marketplaceId, asin, pageToken, null, null);
        Type localVarReturnType = new TypeToken<SearchContentPublishRecordsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call searchContentPublishRecordsAsync(String marketplaceId, String asin, String pageToken, final ApiCallback<SearchContentPublishRecordsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.searchContentPublishRecordsValidateBeforeCall(marketplaceId, asin, pageToken, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SearchContentPublishRecordsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateContentDocumentCall(String contentReferenceKey, String marketplaceId, PostContentDocumentRequest postContentDocumentRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        PostContentDocumentRequest localVarPostBody = postContentDocumentRequest;
        String localVarPath = "/aplus/2020-11-01/contentDocuments/{contentReferenceKey}".replaceAll("\\{contentReferenceKey\\}", this.apiClient.escapeString(contentReferenceKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateContentDocumentValidateBeforeCall(String contentReferenceKey, String marketplaceId, PostContentDocumentRequest postContentDocumentRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (contentReferenceKey == null) {
            throw new ApiException("Missing the required parameter 'contentReferenceKey' when calling updateContentDocument(Async)");
        }
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling updateContentDocument(Async)");
        }
        if (postContentDocumentRequest == null) {
            throw new ApiException("Missing the required parameter 'postContentDocumentRequest' when calling updateContentDocument(Async)");
        }
        Call call = this.updateContentDocumentCall(contentReferenceKey, marketplaceId, postContentDocumentRequest, progressListener, progressRequestListener);
        return call;
    }

    public PostContentDocumentResponse updateContentDocument(String contentReferenceKey, String marketplaceId, PostContentDocumentRequest postContentDocumentRequest) throws ApiException {
        ApiResponse<PostContentDocumentResponse> resp = this.updateContentDocumentWithHttpInfo(contentReferenceKey, marketplaceId, postContentDocumentRequest);
        return resp.getData();
    }

    public ApiResponse<PostContentDocumentResponse> updateContentDocumentWithHttpInfo(String contentReferenceKey, String marketplaceId, PostContentDocumentRequest postContentDocumentRequest) throws ApiException {
        Call call = this.updateContentDocumentValidateBeforeCall(contentReferenceKey, marketplaceId, postContentDocumentRequest, null, null);
        Type localVarReturnType = new TypeToken<PostContentDocumentResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateContentDocumentAsync(String contentReferenceKey, String marketplaceId, PostContentDocumentRequest postContentDocumentRequest, final ApiCallback<PostContentDocumentResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateContentDocumentValidateBeforeCall(contentReferenceKey, marketplaceId, postContentDocumentRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PostContentDocumentResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call validateContentDocumentAsinRelationsCall(String marketplaceId, PostContentDocumentRequest postContentDocumentRequest, List<String> asinSet, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        PostContentDocumentRequest localVarPostBody = postContentDocumentRequest;
        String localVarPath = "/aplus/2020-11-01/contentAsinValidations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (marketplaceId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("marketplaceId", marketplaceId));
        }
        if (asinSet != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "asinSet", asinSet));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call validateContentDocumentAsinRelationsValidateBeforeCall(String marketplaceId, PostContentDocumentRequest postContentDocumentRequest, List<String> asinSet, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (marketplaceId == null) {
            throw new ApiException("Missing the required parameter 'marketplaceId' when calling validateContentDocumentAsinRelations(Async)");
        }
        if (postContentDocumentRequest == null) {
            throw new ApiException("Missing the required parameter 'postContentDocumentRequest' when calling validateContentDocumentAsinRelations(Async)");
        }
        Call call = this.validateContentDocumentAsinRelationsCall(marketplaceId, postContentDocumentRequest, asinSet, progressListener, progressRequestListener);
        return call;
    }

    public ValidateContentDocumentAsinRelationsResponse validateContentDocumentAsinRelations(String marketplaceId, PostContentDocumentRequest postContentDocumentRequest, List<String> asinSet) throws ApiException {
        ApiResponse<ValidateContentDocumentAsinRelationsResponse> resp = this.validateContentDocumentAsinRelationsWithHttpInfo(marketplaceId, postContentDocumentRequest, asinSet);
        return resp.getData();
    }

    public ApiResponse<ValidateContentDocumentAsinRelationsResponse> validateContentDocumentAsinRelationsWithHttpInfo(String marketplaceId, PostContentDocumentRequest postContentDocumentRequest, List<String> asinSet) throws ApiException {
        Call call = this.validateContentDocumentAsinRelationsValidateBeforeCall(marketplaceId, postContentDocumentRequest, asinSet, null, null);
        Type localVarReturnType = new TypeToken<ValidateContentDocumentAsinRelationsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call validateContentDocumentAsinRelationsAsync(String marketplaceId, PostContentDocumentRequest postContentDocumentRequest, List<String> asinSet, final ApiCallback<ValidateContentDocumentAsinRelationsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.validateContentDocumentAsinRelationsValidateBeforeCall(marketplaceId, postContentDocumentRequest, asinSet, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ValidateContentDocumentAsinRelationsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public static class Builder {
        private AWSAuthenticationCredentials awsAuthenticationCredentials;
        private LWAAuthorizationCredentials lwaAuthorizationCredentials;
        private String endpoint;
        private LWAAccessTokenCache lwaAccessTokenCache;
        private Boolean disableAccessTokenCache = false;
        private AWSAuthenticationCredentialsProvider awsAuthenticationCredentialsProvider;

        public Builder awsAuthenticationCredentials(AWSAuthenticationCredentials awsAuthenticationCredentials) {
            this.awsAuthenticationCredentials = awsAuthenticationCredentials;
            return this;
        }

        public Builder lwaAuthorizationCredentials(LWAAuthorizationCredentials lwaAuthorizationCredentials) {
            this.lwaAuthorizationCredentials = lwaAuthorizationCredentials;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder lwaAccessTokenCache(LWAAccessTokenCache lwaAccessTokenCache) {
            this.lwaAccessTokenCache = lwaAccessTokenCache;
            return this;
        }

        public Builder disableAccessTokenCache() {
            this.disableAccessTokenCache = true;
            return this;
        }

        public Builder awsAuthenticationCredentialsProvider(AWSAuthenticationCredentialsProvider awsAuthenticationCredentialsProvider) {
            this.awsAuthenticationCredentialsProvider = awsAuthenticationCredentialsProvider;
            return this;
        }

        public AplusContentApi build() {
            if (this.awsAuthenticationCredentials == null) {
                throw new RuntimeException("AWSAuthenticationCredentials not set");
            }
            if (this.lwaAuthorizationCredentials == null) {
                throw new RuntimeException("LWAAuthorizationCredentials not set");
            }
            if (StringUtil.isEmpty(this.endpoint)) {
                throw new RuntimeException("Endpoint not set");
            }
            AWSSigV4Signer awsSigV4Signer = this.awsAuthenticationCredentialsProvider == null ? new AWSSigV4Signer(this.awsAuthenticationCredentials) : new AWSSigV4Signer(this.awsAuthenticationCredentials, this.awsAuthenticationCredentialsProvider);
            LWAAuthorizationSigner lwaAuthorizationSigner = null;
            if (this.disableAccessTokenCache.booleanValue()) {
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials);
            } else {
                if (this.lwaAccessTokenCache == null) {
                    this.lwaAccessTokenCache = new LWAAccessTokenCacheImpl();
                }
                lwaAuthorizationSigner = new LWAAuthorizationSigner(this.lwaAuthorizationCredentials, this.lwaAccessTokenCache);
            }
            return new AplusContentApi(new ApiClient().setAWSSigV4Signer(awsSigV4Signer).setLWAAuthorizationSigner(lwaAuthorizationSigner).setBasePath(this.endpoint));
        }
    }
}

